/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.bot;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.bot.ChatSection;
import io.intino.cesar.box.bot.RestBot;
import java.util.Arrays;

public class ManageContext
extends ChatSection {
    public ManageContext(CesarBox box) {
        super(box);
    }

    public String addResponsible(RestBot.MessageProperties properties, String user, String email, String[] fullName) {
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("add", properties.username(), "User", user, String.join((CharSequence)" ", Arrays.copyOfRange(fullName, 2, fullName.length)), ManageContext.cleanURL(email)));
        return ":ok_hand:";
    }

    public String removeResponsible(RestBot.MessageProperties properties, String user) {
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("remove", properties.username(), "User", user, new String[0]));
        return ":ok_hand:";
    }

    public String addDevices(RestBot.MessageProperties properties, String[] devices) {
        StringBuilder builder = new StringBuilder();
        for (String tuple : devices) {
            String[] split = tuple.split(";");
            String result = this.addDevice(properties, split[0], split[1]);
            if (result.isEmpty()) continue;
            builder.append(split[1]).append("> ").append(result).append("\n");
        }
        String message = builder.toString();
        return message.isEmpty() ? ":ok_hand:" : message;
    }

    public String addDevice(RestBot.MessageProperties properties, String deviceId, String name) {
        String result = this.canAddDevice(deviceId, name);
        if (!result.isEmpty()) {
            return result;
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("add", properties.username(), "Device", deviceId, name));
        return ":ok_hand:";
    }

    public String removeDevice(RestBot.MessageProperties properties, String deviceId) {
        String result = this.canRemoveDevice(deviceId);
        if (!result.isEmpty()) {
            return result;
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("remove", properties.username(), "Device", this.graph().searchDeviceByNameOrLabel(deviceId).core$().id(), new String[0]));
        return ":ok_hand:";
    }

    public String removeServer(RestBot.MessageProperties properties, String name) {
        String result = this.canRemoveServer(name);
        if (!result.isEmpty()) {
            return result;
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("remove", properties.username(), "Server", this.graph().server(name).core$().id(), new String[0]));
        return ":ok_hand:";
    }

    private String canAddDevice(String deviceId, String name) {
        return this.graph().searchDeviceByNameOrLabel(deviceId) != null || this.graph().searchDeviceByNameOrLabel(name) != null ? "Device id or name already exists" : "";
    }

    private String canRemoveDevice(String deviceId) {
        return this.graph().searchDeviceByNameOrLabel(deviceId) == null ? "Device id not found" : "";
    }

    private String canRemoveServer(String name) {
        return this.graph().server(name) == null ? "Server not found" : "";
    }

    public String datalake(RestBot.MessageProperties properties) {
        properties.context().command("manage|datalake");
        return "Connected to Datalake";
    }

    private static String cleanURL(String url) {
        return url.contains("|") ? url.split("\\|")[1].replaceAll(">|<", "") : url.replace("<", "").replace(">", "");
    }
}

