/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.bot;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.bot.ChatSection;
import io.intino.cesar.box.bot.RestBot;
import io.intino.cesar.box.bot.helpers.BotMessageFormatter;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.User;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class MainContext
extends ChatSection {
    public MainContext(CesarBox box) {
        super(box);
    }

    public String devices(RestBot.MessageProperties properties) {
        int index = 1;
        StringBuilder builder = new StringBuilder();
        List<Device> devices = this.graph().deviceList();
        if (devices.isEmpty()) {
            return builder.toString().isEmpty() ? "There aren't devices registered yet" : builder.toString();
        }
        for (Device d : devices) {
            builder.append("`").append(index++).append(")` ").append(MainContext.label(d)).append("\t").append(BotMessageFormatter.format(d, properties.timeZone())).append("\n");
        }
        return builder.toString();
    }

    public String devicesId(RestBot.MessageProperties properties) {
        StringBuilder result = new StringBuilder();
        this.graph().deviceList().forEach(d -> result.append(MainContext.label(d)).append("\t").append(d.name$()).append("\n"));
        return result.toString().isEmpty() ? "There aren't devices registered yet" : result.toString();
    }

    public String assets(RestBot.MessageProperties properties) {
        return this.devices(properties) + "\n" + this.servers(properties);
    }

    public String servers(RestBot.MessageProperties properties) {
        AtomicInteger pos = new AtomicInteger(1);
        StringBuilder builder = new StringBuilder();
        List<Server> servers = this.graph().serverList();
        if (servers.isEmpty()) {
            return builder.toString().isEmpty() ? "There aren't servers registered yet" : builder.toString();
        }
        servers.forEach(server -> builder.append("`").append(pos.getAndIncrement()).append(")` ").append(this.icon((Server)server)).append(" ").append(server.label()).append(BotMessageFormatter.format(server, properties.timeZone())).append("\n"));
        return builder.toString();
    }

    public String feeders(RestBot.MessageProperties properties) {
        return "";
    }

    public String responsibles(RestBot.MessageProperties properties) {
        StringBuilder builder = new StringBuilder();
        for (User user : this.graph().userList()) {
            builder.append(user.fullName());
            builder.append(" (").append(user.name$()).append("): ");
            builder.append(" ").append(user.mail()).append("\n");
        }
        String message = builder.toString();
        return message.trim().isEmpty() ? "There aren't responsibles registered" : message;
    }

    public String notifications(RestBot.MessageProperties properties, String state) {
        if (state.isEmpty()) {
            return "Notifications are " + (this.graph().configuration().notifications() ? "on" : "off");
        }
        if (!state.equals("on") && !state.equals("off")) {
            return "State does not match (on /off)";
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("Notifications", properties.username(), "Configuration", null, "" + state.equals("on")));
        return ":ok_hand:";
    }

    public String issues(RestBot.MessageProperties properties) {
        int current;
        StringBuilder result = new StringBuilder();
        List<Device> devices = this.graph().deviceList();
        List<Server> servers = this.graph().serverList();
        int pos = 1;
        for (Device d : devices) {
            current = pos++;
            if (d.status() != null && !d.isCompromised()) continue;
            result.append("`").append(current).append(")` ").append(MainContext.label(d)).append("\t").append(BotMessageFormatter.formatCompromised(d, properties.timeZone())).append("\n");
        }
        for (Server s : servers) {
            current = pos++;
            if (s.status() != null && !s.isCompromised()) continue;
            result.append("`").append(current).append(")` ").append((String)(s.status() == null || s.isCompromised() ? "*" + s.label() + "*" : s.label())).append("\t").append(BotMessageFormatter.formatCompromised(s, properties.timeZone())).append("\n");
        }
        return result.toString().isEmpty() ? "There aren't issues" : result.toString();
    }

    public String manage(RestBot.MessageProperties properties) {
        properties.context().command("manage");
        return "Now you are in management area";
    }

    public String device(RestBot.MessageProperties properties, String deviceId) {
        Device selected = this.graph().searchDeviceByPosition(deviceId);
        if (selected == null) {
            selected = this.graph().searchDeviceByLabel(deviceId);
        }
        if (selected == null) {
            return "No device has been connected";
        }
        properties.context().command("device");
        properties.context().objects(selected.name$());
        return "Connected to " + selected.label();
    }

    public String server(RestBot.MessageProperties properties, String name) {
        Server server = this.graph().findServerByPosition(name);
        if (server == null) {
            server = this.graph().server(name);
        }
        if (server == null) {
            return "Server not found";
        }
        properties.context().command("server");
        properties.context().objects(server.name$());
        return "Connected to " + this.icon(server) + " " + server.label();
    }

    private static String label(Device device) {
        return device.status() == null || device.isCompromised() ? "*" + device.label() + "*" : device.label();
    }
}

