/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.bot;

import io.intino.cesar.box.bot.helpers.BotMessageFormatter;
import io.intino.cesar.graph.ProcessStatus;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.DefaultCategoryDataset;

public class LineChartBuilder {
    public static final int WIDTH = 1024;
    public static final int HEIGHT = 480;

    public static BufferedImage build(List<ProcessStatus> statuses, Function<ProcessStatus, Double> mapper, String title, String unit, String timeZone) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        AtomicInteger i = new AtomicInteger();
        statuses.forEach(s -> LineChartBuilder.addValue(mapper, title, timeZone, dataset, i.incrementAndGet(), s));
        JFreeChart lineChart = ChartFactory.createLineChart(title, "Date", unit, dataset, PlotOrientation.VERTICAL, false, false, false);
        lineChart.getPlot().setBackgroundPaint(Color.WHITE);
        lineChart.getPlot().setOutlineStroke(new BasicStroke(2.0f));
        ((CategoryPlot)lineChart.getPlot()).setRenderer(LineChartBuilder.renderer());
        lineChart.setBackgroundPaint(Color.WHITE);
        return lineChart.createBufferedImage(1024, 480);
    }

    private static void addValue(Function<ProcessStatus, Double> mapper, String title, String timeZone, DefaultCategoryDataset dataset, int i, ProcessStatus s) {
        dataset.addValue(mapper.apply(s), (Comparable)((Object)title), (Comparable)((Object)BotMessageFormatter.shortTimeInstant(s.ts(), timeZone)));
    }

    private static CategoryItemRenderer renderer() {
        LineAndShapeRenderer renderer = new LineAndShapeRenderer(){
            final Stroke solid = new BasicStroke(3.0f);

            @Override
            public Stroke getItemStroke(int row, int column) {
                return this.solid;
            }
        };
        renderer.setBaseShapesVisible(true);
        renderer.setBaseShapesFilled(true);
        renderer.setBaseStroke(new BasicStroke(3.0f));
        return renderer;
    }
}

