/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.actions;

import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Forbidden;
import io.intino.alexandria.http.spark.SparkContext;
import io.intino.alexandria.logger.Logger;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.NotificationConsumer;
import io.intino.cesar.box.accessors.ServerProcessDeployer;
import io.intino.cesar.box.schemas.ProcessDeployment;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.User;

public class PostDeployProcessAction {
    public SparkContext context;
    public ProcessDeployment deployment;
    public CesarBox box;

    public void execute() throws BadRequest, Forbidden {
        if (this.deployment == null) {
            throw new BadRequest("Deployment schema does not complies this api version");
        }
        User developer = this.deployer();
        Logger.info("Requested deployment by " + developer.fullName());
        ServerConsul consul = this.findConsul();
        if (this.deployment.requirements() == null) {
            this.deployment.requirements(new ProcessDeployment.Requirements());
        }
        this.deploy(developer, consul);
    }

    private ServerConsul findConsul() throws Forbidden {
        if (!this.isAuthorized()) {
            throw new Forbidden("User '" + (String)this.context.get("Authorization") + "' has not permissions");
        }
        ServerConsul consul = this.searchConsulCandidate();
        if (consul == null) {
            this.notifyResult("Deploying artifact `" + this.deployment.groupId() + ":" + this.deployment.artifactId() + ":" + this.deployment.version() + "` on " + this.deployment.destinationServer() + ": *Server not found*");
            String message = "Impossible to deploy " + this.deployment.artifactId() + ". Server not found";
            Logger.info(message);
            throw new Forbidden("Impossible to deploy " + this.deployment.artifactId() + ". Server not found");
        }
        if (!consul.isAlive().booleanValue()) {
            String message = "Impossible to deploy " + this.deployment.artifactId() + ". Server " + consul.core$().ownerAs(Server.class).label() + " is offline";
            Logger.info(message);
            throw new Forbidden(message);
        }
        return consul;
    }

    private void deploy(User user, ServerConsul consul) {
        new Thread(() -> new ServerProcessDeployer(this.box, consul, this.deployment, user).deploy()).start();
    }

    private boolean isAuthorized() {
        return this.deployer() != null;
    }

    private User deployer() {
        return this.box.graph().userList().stream().filter(r -> r.token().equals(this.context.get("Authorization"))).findFirst().orElse(null);
    }

    private void notifyResult(String message) {
        this.box.chat().sendToUser(this.deployer().name$(), message);
        NotificationConsumer consumer = this.box.notificationSubscribers(this.deployer().name$());
        if (consumer != null) {
            consumer.accept(message);
        }
    }

    private ServerConsul searchConsulCandidate() {
        Server server = this.box.graph().serverList(s -> this.deployment.destinationServer().equals(s.label()) || this.deployment.destinationServer().equals(s.name$())).findFirst().orElse(null);
        return server == null ? null : server.serverConsul();
    }

    private void checkIfFits(ServerConsul consul, Process process) throws Forbidden {
        if (process == null) {
            if (!consul.fitsNew(this.deployment.requirements().minMemory(), this.deployment.requirements().hdd() * 1024.0)) {
                Logger.info("Impossible to deploy " + this.deployment.artifactId() + ". Process does not fit in this server. Check your requirements.");
                throw new Forbidden("Process does not fit in this server. Check your requirements. By default 512Mb of memory and 2Gb of hard disk");
            }
        } else if (!consul.fits(process, this.deployment.requirements().minMemory(), this.deployment.requirements().hdd() * 1024.0)) {
            Logger.info("Impossible to deploy " + this.deployment.artifactId() + ". Process does not fit in this server. Check your requirements.");
            throw new Forbidden("Process does not fit in this server. Check your requirements. By default 512Mb of memory and 2Gb of hard disk");
        }
    }

    private Process findCurrentProcess() {
        return this.box.graph().processesOn(this.deployment.destinationServer()).stream().filter(process -> process.identifier().equals(this.deployment.groupId() + ":" + this.deployment.artifactId())).findFirst().orElse(null);
    }
}

