/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.actions.ProcessAction;
import io.intino.cesar.graph.Process;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;

public class GetProcessLogAction
extends ProcessAction {
    private static final int MESSAGE_PAGE_SIZE = 30;
    public CesarBox box;
    public Context context = new Context();
    public String server;
    public String process;
    public Integer page;

    public String execute() throws BadRequest {
        Process process = this.findProcess(this.box, this.server, this.process);
        List<File> logFiles = process.logs();
        Collections.sort(logFiles);
        Collections.reverse(logFiles);
        ArrayList messages = new ArrayList();
        for (File log : logFiles) {
            if (messages.size() >= 30) break;
            MessageReader iterator = this.iterator(log);
            if (iterator == null) {
                throw new BadRequest("Impossible to retrieve log");
            }
            List<Message> newMessages = IteratorUtils.toList(iterator);
            newMessages = newMessages.subList(this.startIndex(newMessages.size(), messages.size()), newMessages.size());
            messages.addAll(0, newMessages.stream().filter(Objects::nonNull).map(Message::toString).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return String.join((CharSequence)"\n\n", messages);
    }

    private int startIndex(int newMessages, int loaded) {
        int free = 30 - loaded;
        return newMessages < free ? 0 : newMessages - free;
    }

    private MessageReader iterator(File log) {
        try {
            return new MessageReader(new FileInputStream(log));
        }
        catch (FileNotFoundException e) {
            Logger.error(e);
            return null;
        }
    }
}

