/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.scheduling.ScheduleAssetCheckerListener;
import java.io.File;
import java.time.ZoneId;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class Sentinels {
    private Sentinels() {
    }

    public static void init(AlexandriaScheduler scheduler, File home, CesarBox box) {
        try {
            JobDetail job = JobBuilder.newJob(ScheduleAssetCheckerListener.class).withIdentity("scheduleAssetChecker").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("Services#scheduleAssetChecker").withSchedule(CronScheduleBuilder.cronSchedule("0 0/15 * 1/1 * ? *").inTimeZone(TimeZone.getTimeZone(ZoneId.of("Atlantic/Canary")))).build()), true);
            scheduler.startSchedules();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    private static Set<Trigger> newSet(Trigger ... triggers) {
        LinkedHashSet<Trigger> set = new LinkedHashSet<Trigger>();
        Collections.addAll(set, triggers);
        return set;
    }
}

