/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageCast;
import io.intino.alexandria.message.MessageReader;
import io.intino.cesar.datahub.events.cesar.InfrastructureOperation;
import io.intino.cesar.datahub.events.cesar.ProcessOperation;
import io.intino.cesar.graph.Perceptible;
import io.intino.cesar.graph.Process;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.collections4.IteratorUtils;

public class MessageManager {
    public static <T> T fromMessage(String message, Class<T> tClass) {
        try {
            if (message.startsWith("[")) {
                return MessageCast.cast(new MessageReader(new ByteArrayInputStream(message.getBytes())).next()).as(tClass);
            }
            return MessageManager.gson().fromJson(message, tClass);
        }
        catch (Throwable e) {
            Logger.error(e);
            return null;
        }
    }

    public static <T> T cast(Message message, Class<T> tClass) {
        try {
            return MessageCast.cast(message).as(tClass);
        }
        catch (IllegalAccessException e) {
            Logger.error(e);
            return null;
        }
    }

    public static List<Message> readMessages(String value) {
        try {
            return IteratorUtils.toList(new MessageReader(value).iterator());
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    public static InfrastructureOperation infrastructureOperationMessage(String operation, String user, Perceptible identifiable, String ... parameters) {
        String objectType = identifiable.getClass().equals(Process.class) ? "Process".toLowerCase() : identifiable.getClass().getSimpleName().toLowerCase();
        return new InfrastructureOperation().ts(Instant.now()).operation(operation).user(user).objectType(objectType).objectID(identifiable.core$().id()).parameters(Arrays.asList(parameters));
    }

    public static InfrastructureOperation processMessage(String operation, String user, Perceptible identifiable, String ... parameters) {
        String objectType = identifiable.getClass().equals(Process.class) ? "Process".toLowerCase() : identifiable.getClass().getSimpleName().toLowerCase();
        return new ProcessOperation().ts(Instant.now()).operation(operation).user(user).objectType(objectType).objectID(identifiable.core$().id()).parameters(Arrays.asList(parameters));
    }

    public static InfrastructureOperation infrastructureOperationMessage(String operation, String user, String identifiable, String objectId, String ... parameters) {
        return new InfrastructureOperation().ts(Instant.now()).operation(operation).user(user).objectType(identifiable).objectID(objectId).parameters(Arrays.asList(parameters));
    }

    public static Gson gson() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)Instant.class), new InstantAdapter()).registerTypeAdapter((Type)((Object)Date.class), new DateAdapter()).create();
    }

    private static class DateAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.getDefault());

        private DateAdapter() {
        }

        @Override
        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            this.df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return new JsonPrimitive(this.df.format(src));
        }

        @Override
        public Date deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            try {
                return this.df.parse(json.getAsString());
            }
            catch (ParseException e) {
                Logger.error(e);
                return null;
            }
        }
    }

    private static class InstantAdapter
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;

        private InstantAdapter() {
        }

        @Override
        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(FORMATTER.format(src));
        }

        @Override
        public Instant deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return FORMATTER.parse((CharSequence)json.getAsString(), Instant::from);
        }
    }
}

