/*
 * Decompiled with CFR 0.152.
 */
package com.github.baloise.rocketchatrestclient.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.github.baloise.rocketchatrestclient.model.Attachment;
import com.github.baloise.rocketchatrestclient.model.Identified;
import com.vdurmont.emoji.Emoji;
import com.vdurmont.emoji.EmojiManager;
import java.util.ArrayList;
import java.util.Arrays;

public class Message
extends Identified {
    private ArrayList<Attachment> attachments;
    private Emoji emoji;
    private String roomId;
    private String text;
    private String alias;
    private String avatar;

    public Message() {
        this.text = "";
        this.attachments = new ArrayList();
    }

    public Message(String message) {
        this.text = message;
        this.attachments = new ArrayList();
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    @JsonSetter(value="msg")
    public void setText(String text) {
        this.text = text;
    }

    @JsonGetter(value="msg")
    public String getText() {
        return this.text;
    }

    @JsonSetter(value="alias")
    public void setUsernameAlias(String alias) {
        this.alias = alias;
    }

    @JsonGetter(value="alias")
    public String getUsernameAlias() {
        return this.alias;
    }

    public void setEmoji(String emoji) {
        this.emoji = EmojiManager.getForAlias(emoji.replaceAll(":", ""));
    }

    public String getEmoji() {
        return this.emoji == null ? null : ":" + this.emoji.getAliases().get(0) + ":";
    }

    @JsonIgnore
    public void setEmojiAvatar(Emoji emoji) {
        this.emoji = emoji;
    }

    @JsonIgnore
    public Emoji getEmojiAvatar() {
        return this.emoji;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAttachments(Attachment[] attachments) {
        this.attachments = new ArrayList<Attachment>(Arrays.asList(attachments));
    }

    public void addAttachment(Attachment attachment) {
        this.attachments.add(attachment);
    }

    public Attachment[] getAttachments() {
        return this.attachments.toArray(new Attachment[this.attachments.size()]);
    }
}

