/*
 * Decompiled with CFR 0.152.
 */
package com.github.baloise.rocketchatrestclient;

import com.github.baloise.rocketchatrestclient.RocketChatClientCallBuilder;
import com.github.baloise.rocketchatrestclient.RocketChatClientResponse;
import com.github.baloise.rocketchatrestclient.RocketChatRestApiV1;
import com.github.baloise.rocketchatrestclient.RocketChatRestApiV1Channels;
import com.github.baloise.rocketchatrestclient.RocketChatRestApiV1Chat;
import com.github.baloise.rocketchatrestclient.RocketChatRestApiV1Groups;
import com.github.baloise.rocketchatrestclient.RocketChatRestApiV1Settings;
import com.github.baloise.rocketchatrestclient.RocketChatRestApiV1Users;
import com.github.baloise.rocketchatrestclient.model.ServerInfo;
import com.mashape.unirest.http.Unirest;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class RocketChatClient {
    private RocketChatClientCallBuilder callBuilder;
    private RocketChatRestApiV1Channels channels;
    private RocketChatRestApiV1Chat chat;
    private RocketChatRestApiV1Groups groups;
    private RocketChatRestApiV1Users users;
    private RocketChatRestApiV1Settings settings;

    public RocketChatClient(String serverUrl, String user, String password) {
        this.callBuilder = new RocketChatClientCallBuilder(serverUrl, user, password);
        this.channels = new RocketChatRestApiV1Channels(this.callBuilder);
        this.chat = new RocketChatRestApiV1Chat(this.callBuilder);
        this.groups = new RocketChatRestApiV1Groups(this.callBuilder);
        this.users = new RocketChatRestApiV1Users(this.callBuilder);
        this.settings = new RocketChatRestApiV1Settings(this.callBuilder);
    }

    public void trustSelfSignedCertificates() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
        Unirest.setHttpClient(httpclient);
    }

    public void logout() throws IOException {
        this.callBuilder.logout();
    }

    public ServerInfo getServerInformation() throws IOException {
        RocketChatClientResponse res = this.callBuilder.buildCall(RocketChatRestApiV1.Info);
        if (!res.isSuccessful()) {
            throw new IOException("The call out to get the server information was unsuccessful: \"" + res.getError() + "\"");
        }
        if (!res.hasServerInfo()) {
            throw new IOException("The server information was not retrieved from the server.");
        }
        return res.getServerInfo();
    }

    public RocketChatRestApiV1Channels getChannelsApi() {
        return this.channels;
    }

    public RocketChatRestApiV1Chat getChatApi() {
        return this.chat;
    }

    public RocketChatRestApiV1Groups getGroupsApi() {
        return this.groups;
    }

    public RocketChatRestApiV1Users getUsersApi() {
        return this.users;
    }

    public RocketChatRestApiV1Settings getSettingsApi() {
        return this.settings;
    }
}

