/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class CharacterObjectDescription
extends AbstractObjectDescription {
    public CharacterObjectDescription() {
        super(Character.class);
        this.setParameterDefinition("value", String.class);
    }

    public Object createObject() {
        String o = (String)this.getParameter("value");
        if (o == null) {
            return null;
        }
        if (o.length() > 0) {
            return new Character(o.charAt(0));
        }
        return null;
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof Character)) {
            throw new ObjectFactoryException("The given object is no java.lang.Character.");
        }
        this.setParameter("value", String.valueOf(o));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractObjectDescription)) {
            return false;
        }
        AbstractObjectDescription abstractObjectDescription = (AbstractObjectDescription)o;
        if (Character.TYPE.equals(abstractObjectDescription.getObjectClass())) {
            return true;
        }
        return Character.class.equals((Object)abstractObjectDescription.getObjectClass());
    }

    public int hashCode() {
        return this.getObjectClass().hashCode();
    }
}

