/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.lang.semantics.constraints.flags;

import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.NodeRoot;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.rules.Size;
import io.intino.magritte.lang.semantics.constraints.flags.FlagChecker;
import io.intino.magritte.lang.semantics.errorcollector.SemanticException;
import io.intino.magritte.lang.semantics.errorcollector.SemanticNotification;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlagCoherenceCheckerFactory {
    private static final Map<String, FlagChecker> checkers = new HashMap<String, FlagChecker>();

    private FlagCoherenceCheckerFactory() {
    }

    public static FlagChecker get(Object key) {
        return checkers.get(key.toString());
    }

    public static SemanticException error(Node node, List<String> flags) {
        return new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.flag.combination", node, flags));
    }

    public static SemanticException error(String message, Node node) {
        return new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, message, node));
    }

    public static SemanticException error(String message, Node node, List<String> parameters) {
        return new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, message, node, parameters));
    }

    static {
        checkers.put(Tag.Private.name().toLowerCase(), new PrivateChecker());
        checkers.put(Tag.Feature.name().toLowerCase(), new FeatureChecker());
        checkers.put(Tag.Component.name().toLowerCase(), new ComponentChecker());
    }

    private static class ComponentChecker
    implements FlagChecker {
        private ComponentChecker() {
        }

        @Override
        public void check(Node node) throws SemanticException {
            if (node.isReference() || !(node.container() instanceof NodeRoot)) {
                return;
            }
            if (node.isReference() && !node.destinyOfReference().is(Tag.Component)) {
                throw FlagCoherenceCheckerFactory.error("declared.node.must.be", node, Collections.singletonList(Tag.Component.name()));
            }
            if (node.flags().contains((Object)Tag.Feature)) {
                throw FlagCoherenceCheckerFactory.error(node, Arrays.asList(Tag.Feature.name(), Tag.Component.name()));
            }
            Size size = node.container().sizeOf(node);
            if (size == null) {
                return;
            }
            if (size.min() != 0 || size.max() != Integer.MAX_VALUE) {
                throw FlagCoherenceCheckerFactory.error("reject.root.component.size", node);
            }
        }
    }

    private static class FeatureChecker
    implements FlagChecker {
        private FeatureChecker() {
        }

        @Override
        public void check(Node node) throws SemanticException {
            if (node.type().equals("MetaConcept")) {
                throw FlagCoherenceCheckerFactory.error("metaconcept.cannot.be", node, Collections.singletonList(Tag.Feature.name()));
            }
            if (node.isReference() && !node.destinyOfReference().is(Tag.Feature)) {
                throw FlagCoherenceCheckerFactory.error("declared.node.must.be", node, Collections.singletonList(Tag.Feature.name()));
            }
        }
    }

    private static class PrivateChecker
    implements FlagChecker {
        private PrivateChecker() {
        }

        @Override
        public void check(Node node) throws SemanticException {
            if (node.flags().contains((Object)Tag.Final)) {
                throw FlagCoherenceCheckerFactory.error(node, Arrays.asList(Tag.Final.name(), Tag.Private.name()));
            }
        }
    }
}

