/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractServer;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.ServerStatus;
import io.intino.cesar.graph.Status;
import io.intino.magritte.framework.Node;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Server
extends AbstractServer {
    ExecutorService service = Executors.newFixedThreadPool(10);

    public Server(Node node) {
        super(node);
    }

    @Override
    public ServerStatus currentStatus() {
        if (this.serverStatusList().isEmpty()) {
            return null;
        }
        return this.serverStatusList().get(this.serverStatusList().size() - 1);
    }

    public List<ServerStatus> serverStatusList() {
        return this.graph().core$().clone().loadStashes(false, this.statusStash()).as(CesarGraph.class).serverStatusList();
    }

    public void add(io.intino.cesar.datahub.events.consul.server.ServerStatus status) {
        this.service.execute(() -> {
            CesarGraph clone = this.graph().core$().clone().as(CesarGraph.class);
            ServerStatus sStatus = clone.create(this.statusStash()).serverStatus(status.ts(), status.cpu(), status.memory(), status.hdd(), status.inboundConnections(), status.outboundConnections(), status.kernelTemperature(), status.temperature());
            if (clone.processStatusList().size() > this.graph().configuration().historySize()) {
                clone.processStatusList().get(0).delete$();
            } else {
                sStatus.save$();
            }
        });
    }

    @Override
    public boolean isCompromised() {
        return this.isDisconnected() || this.isRunningOutOfDisk() || this.isRunningOutOfMemory();
    }

    @Override
    public boolean isDisconnected() {
        ServerStatus status = this.currentStatus();
        return status == null || status.ts().until(Instant.now(), ChronoUnit.MINUTES) > (long)this.graph().configuration().serverDisconnectedTimeThreshold;
    }

    @Override
    public boolean isRunningOutOfDisk() {
        ServerStatus status = this.currentStatus();
        if (status == null) {
            return false;
        }
        return status.diskUsage() > 90.0;
    }

    public boolean isRunningOutOfMemory() {
        ServerStatus status = this.currentStatus();
        if (this.status == null) {
            return false;
        }
        return status.memoryUsage() > 90.0;
    }

    public boolean isHot() {
        ServerStatus status = this.currentStatus();
        if (status == null) {
            return false;
        }
        return status.kernelTemperature() >= (double)this.graph().configuration().serverKernelTemperatureThreshold();
    }

    public boolean isCpuFull() {
        int count = 0;
        for (Status status : this.serverStatusList()) {
            if (!(status.a$(ServerStatus.class).cpuUsage > 98.0)) continue;
            ++count;
        }
        return (double)count > (double)this.serverStatusList().size() * 0.8;
    }

    private String statusStash() {
        return "status/" + this.name$();
    }

    public static class HDD
    extends AbstractServer.AbstractHDD {
        public HDD(Node node) {
            super(node);
        }
    }

    public static class CPU
    extends AbstractServer.AbstractCPU {
        public CPU(Node node) {
            super(node);
        }
    }

    public static class Memory
    extends AbstractServer.AbstractMemory {
        public Memory(Node node) {
            super(node);
        }
    }

    public static class RemoteConnection
    extends AbstractServer.AbstractRemoteConnection {
        public RemoteConnection(Node node) {
            super(node);
        }
    }
}

