/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.datahub.events.Operations;
import io.intino.cesar.graph.AbstractProcess;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Operation;
import io.intino.cesar.graph.ProcessStatus;
import io.intino.cesar.graph.Server;
import io.intino.magritte.framework.Node;
import java.io.File;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Process
extends AbstractProcess {
    ExecutorService service = Executors.newFixedThreadPool(10);

    public Process(Node node) {
        super(node);
    }

    public ProcessStatus currentStatus() {
        if (this.processStatusList().isEmpty()) {
            return null;
        }
        return this.processStatusList().get(this.processStatusList().size() - 1);
    }

    public List<ProcessStatus> processStatusList() {
        return this.graph().core$().clone().loadStashes(false, this.statusStash()).as(CesarGraph.class).processStatusList();
    }

    public void add(io.intino.cesar.datahub.events.consul.process.ProcessStatus status) {
        this.service.execute(() -> {
            CesarGraph clone = this.graph().core$().clone().as(CesarGraph.class);
            ProcessStatus processStatus = clone.create(this.statusStash()).processStatus(status.ts(), status.cpu(), status.memory(), status.threads(), status.workspaceSize(), status.workspaceTotalSize());
            if (clone.processStatusList().size() > this.graph().configuration().historySize()) {
                clone.processStatusList().get(0).delete$();
            } else {
                processStatus.save$();
            }
        });
    }

    public List<File> logs() {
        File logs = this.logsDirectory();
        if (!logs.exists()) {
            logs.mkdirs();
        }
        return Arrays.asList(Objects.requireNonNull(logs.listFiles(file -> file.getName().endsWith(".log"))));
    }

    public Server deployedServer() {
        return this.consul.core$().ownerAs(Server.class);
    }

    private String statusStash() {
        return "status/" + this.graph().serverOf(this).name$() + "/" + this.identifier().replace(":", "_");
    }

    private File logsDirectory() {
        File file = new File(this.graph().store().directory(), "logs/" + this.graph().serverOf(this).name$() + "/" + this.identifier().replaceFirst(":", "_"));
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public File currentLog() {
        return new File(this.logsDirectory(), this.dayOf(Instant.now().toString()) + ".log");
    }

    @Override
    public void delete$() {
        this.logs().forEach(File::delete);
        super.delete$();
    }

    public boolean isRunningOutOfMemory(Instant ts) {
        return false;
    }

    public boolean isRunningOutOfCpu(Instant ts) {
        return false;
    }

    public boolean isStopped() {
        ProcessStatus processStatus = this.currentStatus();
        return !this.started() || processStatus == null || this.currentStatus() != null && this.currentStatus().ts().until(Instant.now(), ChronoUnit.HOURS) > (long)this.graph().configuration().stoppedTimeThreshold();
    }

    public Deployment currentDeployment() {
        return this.deploymentList().isEmpty() ? null : this.deployment(this.deploymentList().size() - 1);
    }

    public boolean isCompromised() {
        return this.isRunningOutOfCpu(Instant.now()) || this.isRunningOutOfCpu(Instant.now()) || this.isStopped();
    }

    public boolean isCompromised(Instant ts) {
        return this.isRunningOutOfCpu(ts) || this.isRunningOutOfCpu(ts) || this.isStopped();
    }

    public void processNewOperations(List<Operations.Operation> newOperations) {
        this.operations().clear().operation(o -> true);
        for (Operations.Operation op : newOperations) {
            Operation operation = this.operations().create().operation(op.name(), op.parameters(), op.description());
            operation.returnType(op.returnType());
        }
    }

    private String dayOf(String instant) {
        return instant.replace("-", "").substring(0, 8);
    }

    public static class Registry
    extends AbstractProcess.AbstractRegistry {
        public Registry(Node node) {
            super(node);
        }
    }

    public static class Operations
    extends AbstractProcess.AbstractOperations {
        public Operations(Node node) {
            super(node);
        }
    }

    public static class Deployment
    extends AbstractProcess.AbstractDeployment {
        public Deployment(Node node) {
            super(node);
        }

        public static class Parameter
        extends AbstractProcess.AbstractDeployment.AbstractParameter {
            public Parameter(Node node) {
                super(node);
            }
        }

        public static class Prerequisites
        extends AbstractProcess.AbstractDeployment.AbstractPrerequisites {
            public Prerequisites(Node node) {
                super(node);
            }

            public static class SyncDirectoryToServer
            extends AbstractProcess.AbstractDeployment.AbstractPrerequisites.AbstractSyncDirectoryToServer {
                public SyncDirectoryToServer(Node node) {
                    super(node);
                }
            }
        }
    }
}

