/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractDevice;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.magritte.framework.Node;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class Device
extends AbstractDevice {
    public Device(Node node) {
        super(node);
    }

    public void add(io.intino.cesar.datahub.events.consul.device.DeviceStatus deviceStatus) {
        CesarGraph clone = this.graph().core$().clone().as(CesarGraph.class);
        DeviceStatus status = clone.create("status/" + this.name$()).deviceStatus(deviceStatus.ts(), deviceStatus.temperature(), deviceStatus.battery(), deviceStatus.cpuUsage(), deviceStatus.isPlugged(), deviceStatus.isScreenOn());
        if (clone.processStatusList().size() > this.graph().configuration().historySize()) {
            clone.processStatusList().get(0).delete$();
        } else {
            status.save$();
        }
        double temperature = deviceStatus.temperature();
        if (temperature < this.temperature().min()) {
            this.temperature().min(temperature);
        } else if (temperature > this.temperature().max()) {
            this.temperature().max(temperature);
        }
        this.save$();
    }

    public List<DeviceStatus> deviceStatusList() {
        return this.graph().core$().clone().loadStashes("status/" + this.name$()).as(CesarGraph.class).deviceStatusList();
    }

    @Override
    public DeviceStatus currentStatus() {
        if (this.deviceStatusList().isEmpty()) {
            return null;
        }
        return this.deviceStatusList().get(this.deviceStatusList().size() - 1);
    }

    @Override
    public boolean isCompromised() {
        return this.isDisconnected() || this.drainingBattery() || this.isHot() || this.isUnPlugged() || !this.isScreenOn();
    }

    public boolean isTemporallyUnavailable() {
        return this.currentStatus() == null || this.currentStatus().ts().until(Instant.now(), ChronoUnit.MINUTES) > (long)this.graph().configuration().temporallyUnavailableTimeThreshold();
    }

    public boolean runningOutBattery() {
        DeviceStatus status = this.currentStatus();
        if (status == null) {
            return false;
        }
        return status.battery() < (double)this.graph().configuration().deviceLowBatteryThreshold();
    }

    public boolean drainingBattery() {
        DeviceStatus status = this.currentStatus();
        if (status == null) {
            return false;
        }
        return status.battery() < (double)this.graph().configuration().deviceDrainingBatteryThreshold();
    }

    public boolean isHot() {
        DeviceStatus status = this.currentStatus();
        if (this.status == null) {
            return false;
        }
        return status.temperature() >= (double)this.graph().configuration().deviceTemperatureThreshold();
    }

    @Override
    public boolean isDisconnected() {
        DeviceStatus status = this.currentStatus();
        return status == null || status.ts().until(Instant.now(), ChronoUnit.HOURS) > (long)this.graph().configuration().disconnectedTimeThreshold();
    }

    public boolean isUnPlugged() {
        DeviceStatus status = this.currentStatus();
        if (status == null) {
            return false;
        }
        return !status.isPlugged();
    }

    public boolean isScreenOn() {
        DeviceStatus status = this.currentStatus();
        if (status == null) {
            return false;
        }
        return status.isScreenOn();
    }

    public boolean isRunningOutOfMemory() {
        return false;
    }

    public boolean isCpuFull() {
        return false;
    }

    @Override
    public boolean isRunningOutOfDisk() {
        return false;
    }

    @Override
    public String toString() {
        return this.label;
    }

    public static class Temperature
    extends AbstractDevice.AbstractTemperature {
        public Temperature(Node node) {
            super(node);
        }
    }

    public static class Screen
    extends AbstractDevice.AbstractScreen {
        public Screen(Node node) {
            super(node);
        }
    }
}

