/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.AbstractGraph;
import io.intino.cesar.graph.AbstractServer;
import io.intino.cesar.graph.CesarStore;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.magritte.framework.Graph;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CesarGraph
extends AbstractGraph {
    public CesarGraph(Graph graph) {
        super(graph);
    }

    public CesarGraph(Graph graph, CesarGraph wrapper) {
        super(graph, wrapper);
    }

    public List<Process> processesOn(String serverName) {
        Server server = this.findServerByNameOrLabel(serverName);
        return server == null ? Collections.emptyList() : server.processList;
    }

    public Process process(String processID) {
        return this.serverList().stream().flatMap(server -> server.processList().stream()).filter(process -> process.name$().equals(processID)).findFirst().orElse(null);
    }

    public Server serverOf(Process process) {
        return process.consul().core$().ownerAs(Server.class);
    }

    public Server server(String name) {
        for (Server server : this.serverList()) {
            if (!server.name$().equals(name)) continue;
            return server;
        }
        return null;
    }

    public Device device(String name) {
        return this.deviceList().stream().filter(device -> device.name$().equals(name)).findFirst().orElse(null);
    }

    public Process process(String server, String identifier) {
        return this.processesOn(server).stream().filter(s -> s.identifier().equals(identifier)).findFirst().orElse(null);
    }

    @Override
    public List<Device> deviceList() {
        return super.deviceList().stream().sorted(CesarGraph::sort).collect(Collectors.toList());
    }

    @Override
    public List<Server> serverList() {
        return this.sortByType(super.serverList());
    }

    public Device searchDeviceByPosition(String id) {
        try {
            List<Device> devices = this.deviceList();
            int position = Integer.parseInt(id);
            return position <= devices.size() ? devices.get(position - 1) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Device searchDeviceByLabel(String label) {
        for (Device device : this.deviceList()) {
            if (!device.label().equals(label)) continue;
            return device;
        }
        return null;
    }

    public Device searchDeviceByName(String name) {
        for (Device device : this.deviceList()) {
            if (!device.name$().equals(name)) continue;
            return device;
        }
        return null;
    }

    public Device searchDeviceByNameOrLabel(String name) {
        for (Device device : this.deviceList()) {
            if (!device.name$().equals(name) && !device.label().equals(name)) continue;
            return device;
        }
        return null;
    }

    public Server findServerByNameOrLabel(String serverName) {
        return this.serverList(s -> s.name$().equals(serverName) || s.label().equals(serverName)).findFirst().orElse(null);
    }

    public Server findServerByName(String name) {
        return this.serverList().stream().filter(s -> s.name$().equals(name)).findFirst().orElse(null);
    }

    public Server findServerByPosition(String pos) {
        try {
            List<Server> servers = this.sortByType(this.serverList());
            int position = Integer.parseInt(pos);
            return position <= servers.size() ? servers.get(position - 1) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public List<Server> sortByType(List<Server> serverList) {
        List<Server> servers = serverList.stream().filter(server -> server.scope() == AbstractServer.Scope.DEV).collect(Collectors.toList());
        servers.addAll(serverList.stream().filter(server -> server.scope() == AbstractServer.Scope.PRE).collect(Collectors.toList()));
        servers.addAll(serverList.stream().filter(server -> server.scope() == AbstractServer.Scope.DEMO).collect(Collectors.toList()));
        servers.addAll(serverList.stream().filter(server -> server.scope() == AbstractServer.Scope.PRO || server.scope() == AbstractServer.Scope.EXP).collect(Collectors.toList()));
        return servers;
    }

    public Process findProcessByPosition(String server, String pos) {
        List<Process> processes = this.processesOn(server);
        try {
            int position = Integer.parseInt(pos);
            return position <= processes.size() ? processes.get(position - 1) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Process.Deployment deploymentByPosition(List<Process.Deployment> deployments, String pos) {
        try {
            int position = Integer.parseInt(pos);
            return position <= deployments.size() ? deployments.get(position - 1) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Process findProcessByName(String server, String name) {
        return this.processesOn(server).stream().filter(process -> process.label().equals(name) || process.name$().equals(name)).findFirst().orElse(null);
    }

    public CesarStore store() {
        return (CesarStore)this.core$().store();
    }

    private static int sort(Device d1, Device d2) {
        return String.CASE_INSENSITIVE_ORDER.compare(d1.name$(), d2.name$());
    }

    private static int sort(Server f1, Server f2) {
        return String.CASE_INSENSITIVE_ORDER.compare(f1.name$(), f2.name$());
    }
}

