/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Consul;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Perceptible;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.functions.SaveImage;
import io.intino.cesar.graph.rules.IssueType;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.DoubleLoader;
import io.intino.magritte.framework.loaders.FunctionLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.ResourceLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractDevice
extends Asset
implements Terminal {
    protected String androidVersion;
    protected List<IssueType> activeIssueSensors = new ArrayList<IssueType>();
    protected Consul consul;
    protected Device.Screen screen;
    protected Device.Temperature temperature;

    public AbstractDevice(Node node) {
        super(node);
    }

    public String androidVersion() {
        return this.androidVersion;
    }

    public Device androidVersion(String value) {
        this.androidVersion = value;
        return (Device)this;
    }

    public Consul consul() {
        return this.consul;
    }

    public Device.Screen screen() {
        return this.screen;
    }

    public Device.Temperature temperature() {
        return this.temperature;
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.consul != null) {
            components.add(this.consul.core$());
        }
        if (this.screen != null) {
            components.add(this.screen.core$());
        }
        if (this.temperature != null) {
            components.add(this.temperature.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("androidVersion", new ArrayList<String>(Collections.singletonList(this.androidVersion)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Consul")) {
            this.consul = node.as(Consul.class);
        }
        if (node.is("Device$Screen")) {
            this.screen = node.as(Device.Screen.class);
        }
        if (node.is("Device$Temperature")) {
            this.temperature = node.as(Device.Temperature.class);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Consul")) {
            this.consul = null;
        }
        if (node.is("Device$Screen")) {
            this.screen = null;
        }
        if (node.is("Device$Temperature")) {
            this.temperature = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("androidVersion")) {
            this.androidVersion = StringLoader.load(values, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("androidVersion")) {
            this.androidVersion = (String)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public CesarGraph graph() {
        return this.core$().graph().as(CesarGraph.class);
    }

    public static abstract class AbstractTemperature
    extends Layer
    implements Terminal {
        protected double min;
        protected double max;

        public AbstractTemperature(Node node) {
            super(node);
        }

        public double min() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public Device.Temperature min(double value) {
            this.min = value;
            return (Device.Temperature)this;
        }

        public Device.Temperature max(double value) {
            this.max = value;
            return (Device.Temperature)this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("min", new ArrayList<Double>(Collections.singletonList(this.min)));
            map.put("max", new ArrayList<Double>(Collections.singletonList(this.max)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("min")) {
                this.min = DoubleLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = DoubleLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("min")) {
                this.min = (Double)values.get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Double)values.get(0);
            }
        }

        public CesarGraph graph() {
            return this.core$().graph().as(CesarGraph.class);
        }
    }

    public static abstract class AbstractScreen
    extends Layer
    implements Terminal {
        protected URL current;
        protected SaveImage save;
        protected int width;
        protected int height;

        public AbstractScreen(Node node) {
            super(node);
        }

        public URL current() {
            return this.current;
        }

        public void save(byte[] image) {
            this.save.save(image);
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public Device.Screen current(URL url, String destination) {
            this.current = url == null ? null : this.graph().core$().save(url, destination, this.current, this.core$());
            return (Device.Screen)this;
        }

        public Device.Screen current(InputStream stream, String destination) {
            this.current = stream == null ? null : this.graph().core$().save(stream, destination, this.current, this.core$());
            return (Device.Screen)this;
        }

        public Device.Screen save(SaveImage value) {
            this.save = FunctionLoader.load(this.save, (Layer)this, SaveImage.class);
            return (Device.Screen)this;
        }

        public Device.Screen width(int value) {
            this.width = value;
            return (Device.Screen)this;
        }

        public Device.Screen height(int value) {
            this.height = value;
            return (Device.Screen)this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("current", new ArrayList<URL>(Collections.singletonList(this.current)));
            map.put("save", this.save != null ? new ArrayList<SaveImage>(Collections.singletonList(this.save)) : Collections.emptyList());
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("current")) {
                this.current = ResourceLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("save")) {
                this.save = FunctionLoader.load(values, (Layer)this, SaveImage.class).get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = IntegerLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = IntegerLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("current")) {
                this.current = (URL)values.get(0);
            } else if (name.equalsIgnoreCase("save")) {
                this.save = FunctionLoader.load(values.get(0), (Layer)this, SaveImage.class);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            }
        }

        public CesarGraph graph() {
            return this.core$().graph().as(CesarGraph.class);
        }
    }

    public class Create
    extends Perceptible.Create {
        public Create(String name) {
            super(name);
        }

        public Consul consul(String version) {
            Consul newElement = AbstractDevice.this.core$().graph().concept(Consul.class).createNode(this.name, AbstractDevice.this.core$()).as(Consul.class);
            newElement.core$().set(newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Device.Screen screen(URL current) {
            Device.Screen newElement = AbstractDevice.this.core$().graph().concept(Device.Screen.class).createNode(this.name, AbstractDevice.this.core$()).as(Device.Screen.class);
            newElement.core$().set(newElement, "current", Collections.singletonList(current));
            return newElement;
        }

        public Device.Temperature temperature(double min, double max) {
            Device.Temperature newElement = AbstractDevice.this.core$().graph().concept(Device.Temperature.class).createNode(this.name, AbstractDevice.this.core$()).as(Device.Temperature.class);
            newElement.core$().set(newElement, "min", Collections.singletonList(min));
            newElement.core$().set(newElement, "max", Collections.singletonList(max));
            return newElement;
        }

        public ServerConsul serverConsul(String version) {
            ServerConsul newElement = AbstractDevice.this.core$().graph().concept(ServerConsul.class).createNode(this.name, AbstractDevice.this.core$()).as(ServerConsul.class);
            newElement.core$().set(newElement, "version", Collections.singletonList(version));
            return newElement;
        }
    }
}

