/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.countermeasures;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.countermeasures.CounterMeasure;
import io.intino.cesar.countermeasures.notifications.EventNotifier;
import io.intino.cesar.countermeasures.notifications.MessageProvider;
import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Perceptible;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.Status;
import io.intino.cesar.graph.rules.IssueType;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;

public class IssueNotification
implements CounterMeasure<Perceptible> {
    private final EventNotifier eventNotifier;
    private final CesarBox box;
    private final IssueType issueType;

    public IssueNotification(CesarBox box, IssueType issueType) {
        this.box = box;
        this.eventNotifier = new EventNotifier(box);
        this.issueType = issueType;
    }

    @Override
    public void start(Perceptible target, String attachment) {
        if (!this.box.graph().configuration().notifications()) {
            return;
        }
        this.eventNotifier.notify(target.responsibles(), this.subject(target), this.body(target, attachment));
    }

    @Override
    public void stop(Perceptible target) {
        String subject = this.stopSubject(target);
        if (!subject.isEmpty()) {
            this.eventNotifier.notify(target.responsibles(), subject, this.stopBody(target));
        }
    }

    private String subject(Perceptible perceptible) {
        return MessageProvider.message(this.issueType.name().toLowerCase() + ".subject", this.parameters(perceptible));
    }

    private String stopSubject(Perceptible perceptible) {
        return MessageProvider.message(this.issueType.name().toLowerCase() + ".subject.stop", this.parameters(perceptible));
    }

    private String body(Perceptible perceptible, String attachment) {
        String message = MessageProvider.message(this.issueType.name().toLowerCase() + ".body", this.parameters(perceptible, attachment));
        if (message.isEmpty()) {
            message = MessageProvider.message(perceptible.type() + "." + this.issueType.name().toLowerCase() + ".body", this.parameters(perceptible, attachment));
        }
        return message;
    }

    private String stopBody(Perceptible perceptible) {
        return MessageProvider.message(this.issueType.name().toLowerCase() + ".body.stop", new String[0]);
    }

    private String[] parameters(Perceptible perceptible) {
        return this.parameters(perceptible, null);
    }

    private String[] parameters(Perceptible target, String attachment) {
        String[] parameters = new String[3];
        parameters[0] = target.label();
        if (this.issueType == IssueType.Log) {
            parameters[1] = target.i$(Process.class) ? this.serverLabel(target) : null;
            parameters[2] = attachment;
        } else if (this.issueType == IssueType.HighTemperature && target.type().equalsIgnoreCase(Device.class.getSimpleName())) {
            parameters[1] = "" + target.graph().configuration().deviceTemperatureThreshold();
        }
        if (this.issueType == IssueType.HighTemperature && target.type().equalsIgnoreCase(Server.class.getSimpleName())) {
            parameters[1] = "" + target.graph().configuration().serverKernelTemperatureThreshold();
        }
        if (this.issueType == IssueType.DrainingBattery) {
            parameters[1] = "" + target.graph().configuration().deviceDrainingBatteryThreshold();
        }
        if (this.issueType == IssueType.RunningOutBattery) {
            parameters[1] = "" + target.graph().configuration().deviceLowBatteryThreshold();
        }
        if (this.issueType == IssueType.Stopped) {
            parameters[1] = target.i$(Process.class) ? this.serverLabel(target) : null;
            parameters[2] = this.format(target.a$(Process.class).currentStatus().ts());
        } else if (this.issueType == IssueType.Disconnected || this.issueType.equals(IssueType.TemporallyUnavailable)) {
            Status status = target.a$(Asset.class).currentStatus();
            parameters[1] = status == null ? "never" : this.format(status.ts());
        }
        return parameters;
    }

    private String serverLabel(Perceptible target) {
        return ":" + target.a$(Process.class).deployedServer().scope().name().toLowerCase() + ": " + target.a$(Process.class).deployedServer().label();
    }

    private String format(Instant instant) {
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneOffset.UTC).format(instant) + " UTC";
    }
}

