/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.rules.IssueType;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessLogChecker {
    private static final Map<String, Message> lastSentMessagesByProcess = new HashMap<String, Message>();
    private static final DateTimeFormatter zonedDateWithMillisTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private static final DateTimeFormatter zonedDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'hh:mm:ssZ");
    private final Process process;
    private final CesarBox box;

    public ProcessLogChecker(CesarBox box, Process process) {
        this.process = process;
        this.box = box;
    }

    public void check(List<Message> messages) {
        messages.stream().filter(message -> message.type().equalsIgnoreCase(Logger.Level.ERROR.name())).forEach(this::dispatch);
        if (this.process.status() == null) {
            return;
        }
        this.checkStopped();
        this.process.save$();
    }

    private void dispatch(Message message) {
        Message lastMessage = lastSentMessagesByProcess.get(this.process.core$().id());
        if (lastMessage == null || !this.isRecurrent(lastMessage, message)) {
            this.box.issueDispatcher().onIssue(this.process, IssueType.Log, message.toString());
        }
        lastSentMessagesByProcess.put(this.process.core$().id(), message);
    }

    private boolean isRecurrent(Message lastMessage, Message message) {
        Instant ts;
        Instant lastTs = this.ts(lastMessage.get("ts").asString());
        return ChronoUnit.MINUTES.between(lastTs, ts = this.ts(message.get("ts").asString())) < 1L;
    }

    private Instant ts(String text) {
        String ts = text.replace("+0000", "Z");
        if (ts.contains("Z")) {
            return Instant.parse(ts);
        }
        try {
            return Instant.from(zonedDateTimeFormatter.parse(ts));
        }
        catch (Exception exception) {
            try {
                return Instant.from(zonedDateWithMillisTimeFormatter.parse(ts));
            }
            catch (Exception exception2) {
                return Instant.now();
            }
        }
    }

    private void checkStopped() {
        if (this.process.isStopped() && !this.process.currentIssues().contains(IssueType.Stopped)) {
            this.box.issueDispatcher().onIssue(this.process, IssueType.Stopped);
        } else if (!this.process.isStopped() && this.process.currentIssues().contains(IssueType.Stopped)) {
            this.box.issueDispatcher().onIssueFinish(this.process, IssueType.Stopped);
        }
    }
}

