/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.accessors;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.NotificationConsumer;
import io.intino.cesar.box.schemas.ProcessDeployment;
import io.intino.cesar.datahub.events.Deploy;
import io.intino.cesar.datahub.events.DeployResult;
import io.intino.cesar.graph.Process;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.User;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ServerProcessDeployer {
    private final CesarBox box;
    private final ServerConsul consul;
    private final ProcessDeployment deployment;
    private final User user;
    private final String artifact;
    private final String identifier;

    public ServerProcessDeployer(CesarBox box, ServerConsul consul, ProcessDeployment deployment, User user) {
        this.box = box;
        this.consul = consul;
        this.deployment = deployment;
        this.user = user;
        this.artifact = this.deployment.groupId() + ":" + deployment.artifactId() + ":" + deployment.version();
        this.identifier = this.deployment.groupId() + ":" + deployment.artifactId();
    }

    public void deploy() {
        Server server = this.consul.core$().ownerAs(Server.class);
        this.deployment.destinationServer(server.name$());
        Process process = this.findProcess();
        Deploy deploy = this.consulSchema(process, server, this.artifact);
        DeployResult deployResult = this.box.serverAccessor(server).deploy(deploy);
        if (deployResult.success().booleanValue()) {
            if (this.registerProcessAndDeploy(process, deploy.id())) {
                this.notifyResult("Process " + this.artifact + " has been deployed to " + server.label() + " successfully.");
            }
        } else {
            this.notifyResult("Error deploying " + this.artifact + " in " + server.name$() + ". " + (deployResult.remarks() != null ? deployResult.remarks() : ""));
        }
    }

    private void notifyResult(String message) {
        this.box.chat().sendToUser(this.user.name$(), message);
        NotificationConsumer consumer = this.box.notificationSubscribers(this.user.name$());
        if (consumer != null) {
            consumer.accept(message);
        }
    }

    private Deploy consulSchema(Process process, Server server, String artifact) {
        Deploy schema = new Deploy();
        schema.id(this.identifier);
        schema.artifact(artifact);
        if (this.deployment.requirements() != null) {
            schema.requirements(new Deploy.Requirements().minMemory(this.deployment.requirements().minMemory()).maxMemory(this.deployment.requirements().maxMemory()).syncFileToServerList(this.filesToSync()));
        }
        schema.classpathPrefix(this.deployment.packaging().classpathPrefix());
        schema.parameterList(this.deployment.packaging().parameterList().stream().map(p -> new Deploy.Parameter().name(p.name()).value(p.value())).collect(Collectors.toList()));
        if (this.deployment.jvmOptions() != null && !this.deployment.jvmOptions().isEmpty()) {
            schema.jVMParameterList(Arrays.stream(this.deployment.jvmOptions().split(" ")).map(p -> new Deploy.JVMParameter().value((String)p)).collect(Collectors.toList()));
        }
        schema.artifactoryList(this.deployment.artifactoryList().stream().map(a -> new Deploy.Artifactory().id(a.id()).url(a.url()).user(a.user()).password(a.password())).collect(Collectors.toList()));
        if (process != null && process.operations().port() != 0) {
            schema.jmxPort(process.operations().port());
        } else {
            this.deployment.jmxPort(server.reserveJMXPort());
            schema.jmxPort(this.deployment.jmxPort());
        }
        return schema;
    }

    private List<Deploy.Requirements.SyncFileToServer> filesToSync() {
        if (this.deployment.requirements().syncFileToServer().isEmpty()) {
            return Collections.emptyList();
        }
        return this.deployment.requirements().syncFileToServer().entrySet().stream().map(e -> new Deploy.Requirements.SyncFileToServer().directory((String)e.getKey()).targetServers(this.ipsWithWorkingDirectory((List)e.getValue()))).collect(Collectors.toList());
    }

    private List<String> ipsWithWorkingDirectory(List<String> servers) {
        return servers.stream().map(s -> this.box.graph().findServerByNameOrLabel((String)s)).filter(Objects::nonNull).map(server -> server.ip() + ":" + server.appsWorkspace()).collect(Collectors.toList());
    }

    private boolean registerProcessAndDeploy(Process process, String artifact) {
        boolean isNew;
        boolean bl = isNew = process == null;
        if (isNew) {
            this.box.committer().commit(MessageManager.infrastructureOperationMessage("Add", this.user.fullName(), "Process", null, MessageManager.gson().toJson(this.deployment)));
            process = this.box.graph().process(this.deployment.destinationServer(), artifact);
        }
        this.box.committer().commit(MessageManager.infrastructureOperationMessage("NewDeployment", this.user.fullName(), "Process", artifact, MessageManager.gson().toJson(this.deployment)));
        if (process != null) {
            if (isNew) {
                this.box.committer().commit(MessageManager.infrastructureOperationMessage("setResponsibles", this.user.name$(), process, this.user.name$()));
            }
            return true;
        }
        Logger.error("Process not found when register deploy. " + artifact + "; server: " + this.deployment.destinationServer());
        return false;
    }

    private Process findProcess() {
        for (Process process : this.box.graph().processesOn(this.deployment.destinationServer())) {
            if (!process.identifier().equals(this.identifier) || !this.consul.equals(process.consul())) continue;
            return process;
        }
        return null;
    }
}

