/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.alexandria.logger.Logger;
import io.intino.cesar.box.UserService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPUserService
implements UserService {
    private final String url;
    private final String baseDN;
    private final String user;
    private final String password;

    public LDAPUserService(String url, String baseDN, String user, String password) {
        this.url = url;
        this.baseDN = baseDN;
        this.user = user;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserService.User> users() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.user);
        env.put("java.naming.security.credentials", this.password);
        InitialDirContext ctx = null;
        NamingEnumeration<SearchResult> results = null;
        ArrayList<UserService.User> users = new ArrayList<UserService.User>();
        try {
            ctx = new InitialDirContext(env);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            results = ctx.search(this.baseDN, "(objectclass=person)", controls);
            while (results.hasMore()) {
                Attributes attributes = results.next().getAttributes();
                if (attributes.get("userpassword") == null || ((byte[])attributes.get("userpassword").get()).length <= 0) continue;
                users.add(this.lubricate(attributes));
            }
            ArrayList<UserService.User> arrayList = users;
            return arrayList;
        }
        catch (NamingException e) {
            Logger.error(e.getMessage());
            List<UserService.User> list = Collections.emptyList();
            return list;
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private UserService.User lubricate(final Attributes attributes) {
        return new UserService.User(){

            @Override
            public String name() {
                try {
                    return attributes.get("cn").get().toString();
                }
                catch (NamingException e) {
                    return "";
                }
            }

            @Override
            public String fullName() {
                try {
                    return attributes.get("displayname").get().toString();
                }
                catch (NamingException e) {
                    return "";
                }
            }

            @Override
            public String password() {
                try {
                    String password = new String((byte[])attributes.get("userpassword").get());
                    return password.substring(password.indexOf("}") + 1);
                }
                catch (NamingException e) {
                    return "";
                }
            }

            @Override
            public String telephone() {
                try {
                    return attributes.get("telephonenumber").get().toString();
                }
                catch (NamingException e) {
                    return "";
                }
            }

            @Override
            public String mail() {
                try {
                    return attributes.get("mail").get().toString();
                }
                catch (NamingException e) {
                    return "";
                }
            }
        };
    }
}

