/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.proxy;

import io.intino.cesar.proxy.ProxyManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Logger;

public class ProxyManagerProvider {
    private static ProxyManager proxyManager = new LocalProxyManager();

    public static void register(ProxyManager manager) {
        proxyManager = manager;
    }

    public static ProxyManager get() {
        return proxyManager;
    }

    public static class LocalProxyManager
    implements ProxyManager {
        public static final Map<String, String> HOSTS_PATHS = new HashMap<String, String>(19);
        private static final Logger LOGGER = Logger.getLogger(LocalProxyManager.class.getName());
        private File hosts = null;
        private String hostsPath = "";
        private Map<String, String> entries = null;
        private List<String> hostOtherEntries = new ArrayList<String>();

        LocalProxyManager() {
            String osName = System.getProperty("os.name");
            this.hostsPath = HOSTS_PATHS.get(osName);
            if (this.hostsPath.equals("unknown") || this.hostsPath.equals("")) {
                return;
            }
            this.hosts = new File(this.hostsPath);
            try {
                this.parse();
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }

        @Override
        public void add(String redirect, String target) {
            if (this.entries == null) {
                return;
            }
            try {
                InetAddress targetAddr = Inet4Address.getByName(target);
                this.entries.put(redirect, targetAddr.getHostAddress());
                this.persist();
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }

        Map<String, String> parse() throws Exception {
            this.entries = new LinkedHashMap<String, String>();
            try {
                if (!this.hosts.canRead()) {
                    throw new Exception("Do not have permission to read file.");
                }
                Scanner in = new Scanner(this.hosts);
                while (in.hasNextLine()) {
                    String[] split;
                    String crntLine = in.nextLine();
                    if (crntLine.contains("#")) {
                        split = crntLine.split("#");
                        if (split.length > 0) {
                            crntLine = split[0].length() > 0 ? split[0].trim() : "";
                            this.hostOtherEntries.add(split[1].length() > 0 ? "#" + split[1] : "#");
                        } else {
                            crntLine = "";
                        }
                    }
                    if (crntLine.contains("\t")) {
                        for (String str : split = crntLine.split("\t")) {
                            str = str.trim();
                        }
                        if (split[0].contains("::")) {
                            this.hostOtherEntries.add(split[0] + "\t" + split[1]);
                            continue;
                        }
                        this.entries.put(split[1], split[0]);
                        continue;
                    }
                    if (!crntLine.contains(" ")) continue;
                    for (String str : split = crntLine.split(" ")) {
                        str = str.trim();
                    }
                    if (split[0].contains("::")) {
                        this.hostOtherEntries.add(split[0] + "\t" + split[1]);
                        continue;
                    }
                    this.entries.put(split[1], split[0]);
                }
            }
            catch (FileNotFoundException ex) {
                LOGGER.severe(ex.getMessage());
            }
            return this.entries;
        }

        public boolean remove(String redirect) {
            if (this.entries == null) {
                return false;
            }
            this.entries.remove(redirect);
            return true;
        }

        public void persist() throws Exception {
            if (!this.hosts.canWrite()) {
                throw new Exception("Does not have permission to write.");
            }
            try (FileOutputStream erasor = new FileOutputStream(this.hosts);){
                erasor.write(new String().getBytes());
                erasor.flush();
            }
            var2_2 = null;
            try (BufferedWriter out = new BufferedWriter(new PrintWriter(this.hosts));){
                for (String comment : this.hostOtherEntries) {
                    out.write(comment + "\n");
                }
                out.write("\n");
                Set<String> keys = this.entries.keySet();
                for (String key : keys) {
                    out.write(this.entries.get(key) + "\t" + key + "\n");
                }
                ((Writer)out).flush();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
        }

        static {
            HOSTS_PATHS.put("AIX", "unknown");
            HOSTS_PATHS.put("Digital Unix", "/etc/hosts");
            HOSTS_PATHS.put("FreeBSD", "/etc/hosts");
            HOSTS_PATHS.put("HP UX", "/etc/hosts");
            HOSTS_PATHS.put("Irix", "unknown");
            HOSTS_PATHS.put("Linux", "/etc/hosts");
            HOSTS_PATHS.put("Mac OS", "unknown");
            HOSTS_PATHS.put("Mac OS X", "/etc/hosts");
            HOSTS_PATHS.put("MPE/iX", "unknown");
            HOSTS_PATHS.put("Netware 4.11", "unknown");
            HOSTS_PATHS.put("OS/2", "unknown");
            HOSTS_PATHS.put("Solaris", "/etc/hosts");
            HOSTS_PATHS.put("Windows 2000", System.getenv("windir") + "\\system32\\drivers\\etc\\hosts");
            HOSTS_PATHS.put("Windows 7", System.getenv("windir") + "\\system32\\drivers\\etc\\hosts");
            HOSTS_PATHS.put("Windows 95", System.getenv("windir") + "\\hosts");
            HOSTS_PATHS.put("Windows 98", System.getenv("windir") + "\\hosts");
            HOSTS_PATHS.put("Windows NT", System.getenv("windir") + "\\system32\\drivers\\etc\\hosts");
            HOSTS_PATHS.put("Windows Vista", System.getenv("windir") + "\\system32\\drivers\\etc\\hosts");
            HOSTS_PATHS.put("Windows XP", System.getenv("windir") + "\\system32\\drivers\\etc\\hosts");
        }
    }
}

