/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.Artifact;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.SystemDigest;
import io.intino.sumus.graph.Entity;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.ObjectLoader;
import io.intino.tara.magritte.loaders.ResourceLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class System
extends Identifiable
implements Terminal {
    protected String url;
    protected int jmxPort;
    protected int debugPort;
    protected ServerConsul consul;
    protected Expression<Boolean> isRunning;
    protected Artifact artifact;
    protected List<Deployment> deploymentList = new ArrayList<Deployment>();
    protected Status status;

    public System(Node node) {
        super(node);
    }

    public String url() {
        return this.url;
    }

    public int jmxPort() {
        return this.jmxPort;
    }

    public int debugPort() {
        return this.debugPort;
    }

    public ServerConsul consul() {
        return this.consul;
    }

    public boolean isRunning() {
        return (Boolean)this.isRunning.value();
    }

    @Override
    public String label() {
        return this._metaType.label();
    }

    public System url(String value) {
        this.url = value;
        return this;
    }

    public System jmxPort(int value) {
        this.jmxPort = value;
        return this;
    }

    public System debugPort(int value) {
        this.debugPort = value;
        return this;
    }

    public System consul(ServerConsul value) {
        this.consul = value;
        return this;
    }

    public System isRunning(Expression<Boolean> value) {
        this.isRunning = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    @Override
    public System label(String value) {
        this._metaType.label(value);
        return this;
    }

    public Artifact artifact() {
        return this.artifact;
    }

    public List<Deployment> deploymentList() {
        return Collections.unmodifiableList(this.deploymentList);
    }

    public Deployment deployment(int index) {
        return this.deploymentList.get(index);
    }

    public List<Deployment> deploymentList(Predicate<Deployment> predicate) {
        return this.deploymentList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Status status() {
        return this.status;
    }

    public System artifact(Artifact value) {
        this.artifact = value;
        return this;
    }

    public System status(Status value) {
        this.status = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.artifact != null) {
            components.add(this.artifact.core$());
        }
        this.deploymentList.stream().forEach(c -> components.add(c.core$()));
        if (this.status != null) {
            components.add(this.status.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
        map.put("jmxPort", new ArrayList<Integer>(Collections.singletonList(this.jmxPort)));
        map.put("debugPort", new ArrayList<Integer>(Collections.singletonList(this.debugPort)));
        map.put("consul", this.consul != null ? new ArrayList<ServerConsul>(Collections.singletonList(this.consul)) : Collections.emptyList());
        map.put("isRunning", new ArrayList<Expression<Boolean>>(Collections.singletonList(this.isRunning)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Artifact")) {
            this.artifact = (Artifact)node.as(Artifact.class);
        }
        if (node.is("System$Deployment")) {
            this.deploymentList.add((Deployment)node.as(Deployment.class));
        }
        if (node.is("System$Status")) {
            this.status = (Status)node.as(Status.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Artifact")) {
            this.artifact = null;
        }
        if (node.is("System$Deployment")) {
            this.deploymentList.remove(node.as(Deployment.class));
        }
        if (node.is("System$Status")) {
            this.status = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("jmxPort")) {
            this.jmxPort = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("debugPort")) {
            this.debugPort = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("consul")) {
            this.consul = (ServerConsul)((Object)NodeLoader.load(values, ServerConsul.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("isRunning")) {
            this.isRunning = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)values.get(0);
        } else if (name.equalsIgnoreCase("jmxPort")) {
            this.jmxPort = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("debugPort")) {
            this.debugPort = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("consul")) {
            this.consul = values.get(0) != null ? (ServerConsul)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(ServerConsul.class) : null;
        } else if (name.equalsIgnoreCase("isRunning")) {
            this.isRunning = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public static class Status
    extends Layer
    implements Terminal {
        protected URL standardOutput;
        protected URL errorOutput;
        protected boolean running;
        protected SystemDigest status;
        protected Entity _metaType = (Entity)this.core$().as(Entity.class);

        public Status(Node node) {
            super(node);
        }

        public URL standardOutput() {
            return this.standardOutput;
        }

        public URL errorOutput() {
            return this.errorOutput;
        }

        public boolean running() {
            return this.running;
        }

        public SystemDigest status() {
            return this.status;
        }

        public String label() {
            return this._metaType.label();
        }

        public Status standardOutput(URL url, String destiny) {
            this.standardOutput = this.graph().core$().save(url, destiny, this.standardOutput, this.core$());
            return this;
        }

        public Status standardOutput(InputStream stream, String destiny) {
            this.standardOutput = this.graph().core$().save(stream, destiny, this.standardOutput, this.core$());
            return this;
        }

        public Status errorOutput(URL url, String destiny) {
            this.errorOutput = this.graph().core$().save(url, destiny, this.errorOutput, this.core$());
            return this;
        }

        public Status errorOutput(InputStream stream, String destiny) {
            this.errorOutput = this.graph().core$().save(stream, destiny, this.errorOutput, this.core$());
            return this;
        }

        public Status running(boolean value) {
            this.running = value;
            return this;
        }

        public Status status(SystemDigest value) {
            this.status = value;
            return this;
        }

        public Status label(String value) {
            this._metaType.label(value);
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("standardOutput", new ArrayList<URL>(Collections.singletonList(this.standardOutput)));
            map.put("errorOutput", new ArrayList<URL>(Collections.singletonList(this.errorOutput)));
            map.put("running", new ArrayList<Boolean>(Collections.singletonList(this.running)));
            map.put("status", new ArrayList<SystemDigest>(Collections.singletonList(this.status)));
            map.put("label", new ArrayList<String>(Collections.singletonList(this._metaType.label())));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this.core$().load((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("standardOutput")) {
                this.standardOutput = (URL)ResourceLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("errorOutput")) {
                this.errorOutput = (URL)ResourceLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("running")) {
                this.running = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("status")) {
                this.status = (SystemDigest)ObjectLoader.load(values, SystemDigest.class, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this.core$().set((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("standardOutput")) {
                this.standardOutput = (URL)values.get(0);
            } else if (name.equalsIgnoreCase("errorOutput")) {
                this.errorOutput = (URL)values.get(0);
            } else if (name.equalsIgnoreCase("running")) {
                this.running = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("status")) {
                this.status = (SystemDigest)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Deployment
    extends Layer
    implements Terminal {
        protected boolean success;
        protected Prerequisites prerequisites;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected Entity _metaType = (Entity)this.core$().as(Entity.class);

        public Deployment(Node node) {
            super(node);
        }

        public boolean success() {
            return this.success;
        }

        public String label() {
            return this._metaType.label();
        }

        public Deployment success(boolean value) {
            this.success = value;
            return this;
        }

        public Deployment label(String value) {
            this._metaType.label(value);
            return this;
        }

        public Prerequisites prerequisites() {
            return this.prerequisites;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Deployment prerequisites(Prerequisites value) {
            this.prerequisites = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.prerequisites != null) {
                components.add(this.prerequisites.core$());
            }
            this.parameterList.stream().forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("success", new ArrayList<Boolean>(Collections.singletonList(this.success)));
            map.put("label", new ArrayList<String>(Collections.singletonList(this._metaType.label())));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("System$Deployment$Prerequisites")) {
                this.prerequisites = (Prerequisites)node.as(Prerequisites.class);
            }
            if (node.is("System$Deployment$Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("System$Deployment$Prerequisites")) {
                this.prerequisites = null;
            }
            if (node.is("System$Deployment$Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this.core$().load((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("success")) {
                this.success = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this.core$().set((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("success")) {
                this.success = (Boolean)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }

        public static class Parameter
        extends Layer
        implements Terminal {
            protected String name;
            protected String value;
            protected Entity _metaType = (Entity)this.core$().as(Entity.class);

            public Parameter(Node node) {
                super(node);
            }

            public String name() {
                return this.name;
            }

            public String value() {
                return this.value;
            }

            public String label() {
                return this._metaType.label();
            }

            public Parameter name(String value) {
                this.name = value;
                return this;
            }

            public Parameter value(String value) {
                this.value = value;
                return this;
            }

            public Parameter label(String value) {
                this._metaType.label(value);
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
                map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
                map.put("label", new ArrayList<String>(Collections.singletonList(this._metaType.label())));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this.core$().load((Layer)this._metaType, name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("value")) {
                    this.value = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this.core$().set((Layer)this._metaType, name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name = (String)values.get(0);
                } else if (name.equalsIgnoreCase("value")) {
                    this.value = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public CesarGraph graph() {
                return (CesarGraph)this.core$().graph().as(CesarGraph.class);
            }

            public class Clear {
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public static class Prerequisites
        extends Layer
        implements Terminal {
            protected int memory;
            protected double hdd;
            protected Performance performance;
            protected Entity _metaType = (Entity)this.core$().as(Entity.class);

            public Prerequisites(Node node) {
                super(node);
            }

            public int memory() {
                return this.memory;
            }

            public double hdd() {
                return this.hdd;
            }

            public Performance performance() {
                return this.performance;
            }

            public String label() {
                return this._metaType.label();
            }

            public Prerequisites memory(int value) {
                this.memory = value;
                return this;
            }

            public Prerequisites hdd(double value) {
                this.hdd = value;
                return this;
            }

            public Prerequisites performance(Performance value) {
                this.performance = value;
                return this;
            }

            public Prerequisites label(String value) {
                this._metaType.label(value);
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("memory", new ArrayList<Integer>(Collections.singletonList(this.memory)));
                map.put("hdd", new ArrayList<Double>(Collections.singletonList(this.hdd)));
                map.put("performance", new ArrayList<Performance>(Collections.singletonList(this.performance)));
                map.put("label", new ArrayList<String>(Collections.singletonList(this._metaType.label())));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this.core$().load((Layer)this._metaType, name, values);
                if (name.equalsIgnoreCase("memory")) {
                    this.memory = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("hdd")) {
                    this.hdd = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("performance")) {
                    this.performance = (Performance)((Object)WordLoader.load(values, Performance.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this.core$().set((Layer)this._metaType, name, values);
                if (name.equalsIgnoreCase("memory")) {
                    this.memory = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("hdd")) {
                    this.hdd = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("performance")) {
                    this.performance = (Performance)((Object)values.get(0));
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public CesarGraph graph() {
                return (CesarGraph)this.core$().graph().as(CesarGraph.class);
            }

            public class Clear {
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }

            public static enum Performance {
                High,
                Medium,
                Low;

            }
        }

        public class Clear {
            public void parameter(Predicate<Parameter> ... filters) {
                new ArrayList<Parameter>(Deployment.this.parameterList()).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Prerequisites prerequisites(int memory, double hdd, Prerequisites.Performance performance) {
                Prerequisites newElement = (Prerequisites)Deployment.this.core$().graph().concept(Prerequisites.class).createNode(this.name, Deployment.this.core$()).as(Prerequisites.class);
                newElement.core$().set((Layer)newElement, "memory", Collections.singletonList(memory));
                newElement.core$().set((Layer)newElement, "hdd", Collections.singletonList(hdd));
                newElement.core$().set((Layer)newElement, "performance", Collections.singletonList(performance));
                return newElement;
            }

            public Parameter parameter(String name, String value) {
                Parameter newElement = (Parameter)Deployment.this.core$().graph().concept(Parameter.class).createNode(name, Deployment.this.core$()).as(Parameter.class);
                newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
                newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                return newElement;
            }
        }
    }

    public class Clear
    extends Identifiable.Clear {
        public void deployment(Predicate<Deployment> ... filters) {
            new ArrayList<Deployment>(System.this.deploymentList()).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Identifiable.Create {
        public Create(String name) {
            super(name);
        }

        public Artifact artifact(String group, String artifactId, String version) {
            Artifact newElement = (Artifact)System.this.core$().graph().concept(Artifact.class).createNode(this.name, System.this.core$()).as(Artifact.class);
            newElement.core$().set((Layer)newElement, "group", Collections.singletonList(group));
            newElement.core$().set((Layer)newElement, "artifactId", Collections.singletonList(artifactId));
            newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Deployment deployment() {
            Deployment newElement = (Deployment)System.this.core$().graph().concept(Deployment.class).createNode(this.name, System.this.core$()).as(Deployment.class);
            return newElement;
        }

        public Status status() {
            Status newElement = (Status)System.this.core$().graph().concept(Status.class).createNode(this.name, System.this.core$()).as(Status.class);
            return newElement;
        }
    }
}

