/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Consul;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.functions.AddSystem;
import io.intino.cesar.graph.functions.FitsSystem;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ServerConsul
extends Consul
implements Component,
Terminal {
    protected int jmxPort;
    protected Expression<String> url;
    protected List<System> systems = new ArrayList<System>();
    protected FitsSystem fitsNew;
    protected AddSystem addSystem;
    protected Expression<Boolean> isAlive;

    public ServerConsul(Node node) {
        super(node);
    }

    public int jmxPort() {
        return this.jmxPort;
    }

    public String url() {
        return (String)this.url.value();
    }

    public List<System> systems() {
        return this.systems;
    }

    public System systems(int index) {
        return this.systems.get(index);
    }

    public List<System> systems(Predicate<System> predicate) {
        return this.systems().stream().filter(predicate).collect(Collectors.toList());
    }

    public boolean fitsNew(System.Deployment deployment) {
        return this.fitsNew.fits(deployment);
    }

    public void addSystem(System system) {
        this.addSystem.add(system);
    }

    public boolean isAlive() {
        return (Boolean)this.isAlive.value();
    }

    @Override
    public String label() {
        return this._metaType.label();
    }

    public ServerConsul jmxPort(int value) {
        this.jmxPort = value;
        return this;
    }

    public ServerConsul url(Expression<String> value) {
        this.url = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    public ServerConsul fitsNew(FitsSystem value) {
        this.fitsNew = (FitsSystem)FunctionLoader.load((Object)this.fitsNew, (Layer)this, FitsSystem.class);
        return this;
    }

    public ServerConsul addSystem(AddSystem value) {
        this.addSystem = (AddSystem)FunctionLoader.load((Object)this.addSystem, (Layer)this, AddSystem.class);
        return this;
    }

    public ServerConsul isAlive(Expression<Boolean> value) {
        this.isAlive = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    @Override
    public ServerConsul label(String value) {
        this._metaType.label(value);
        return this;
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("jmxPort", new ArrayList<Integer>(Collections.singletonList(this.jmxPort)));
        map.put("url", new ArrayList<Expression<String>>(Collections.singletonList(this.url)));
        map.put("systems", this.systems);
        map.put("fitsNew", this.fitsNew != null ? new ArrayList<FitsSystem>(Collections.singletonList(this.fitsNew)) : Collections.emptyList());
        map.put("addSystem", this.addSystem != null ? new ArrayList<AddSystem>(Collections.singletonList(this.addSystem)) : Collections.emptyList());
        map.put("isAlive", new ArrayList<Expression<Boolean>>(Collections.singletonList(this.isAlive)));
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("jmxPort")) {
            this.jmxPort = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("url")) {
            this.url = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        } else if (name.equalsIgnoreCase("systems")) {
            this.systems = NodeLoader.load(values, System.class, (Layer)this);
        } else if (name.equalsIgnoreCase("fitsNew")) {
            this.fitsNew = (FitsSystem)FunctionLoader.load(values, (Layer)this, FitsSystem.class).get(0);
        } else if (name.equalsIgnoreCase("addSystem")) {
            this.addSystem = (AddSystem)FunctionLoader.load(values, (Layer)this, AddSystem.class).get(0);
        } else if (name.equalsIgnoreCase("isAlive")) {
            this.isAlive = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("jmxPort")) {
            this.jmxPort = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("url")) {
            this.url = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        } else if (name.equalsIgnoreCase("systems")) {
            this.systems = values.stream().map(s -> (System)this.graph().core$().load(((Layer)s).core$().id()).as(System.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("fitsNew")) {
            this.fitsNew = (FitsSystem)FunctionLoader.load(values.get(0), (Layer)this, FitsSystem.class);
        } else if (name.equalsIgnoreCase("addSystem")) {
            this.addSystem = (AddSystem)FunctionLoader.load(values.get(0), (Layer)this, AddSystem.class);
        } else if (name.equalsIgnoreCase("isAlive")) {
            this.isAlive = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public class Clear
    extends Consul.Clear {
    }

    public class Create
    extends Consul.Create {
        public Create(String name) {
            super(name);
        }
    }
}

