/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CPU;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.HDD;
import io.intino.cesar.graph.Memory;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.ServerDigest;
import io.intino.cesar.graph.Unit;
import io.intino.cesar.graph.functions.PortRelease;
import io.intino.cesar.graph.functions.PortReservation;
import io.intino.sumus.graph.Entity;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.ObjectLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Server
extends Unit
implements Component,
Terminal {
    protected List<Sensors> sensors = new ArrayList<Sensors>();
    protected List<Active> active = new ArrayList<Active>();
    protected String ip;
    protected String url;
    protected Performance performance;
    protected List<Integer> usedPorts = new ArrayList<Integer>();
    protected PortReservation reservePort;
    protected PortRelease releasePort;
    protected Expression<Boolean> isDisconnected;
    protected ServerDigest status;
    protected ServerConsul serverConsul;
    protected RemoteConnection remoteConnection;
    protected Memory memory;
    protected CPU cPU;
    protected HDD hDD;

    public Server(Node node) {
        super(node);
    }

    public List<Sensors> sensors() {
        return this.sensors;
    }

    public List<Active> active() {
        return this.active;
    }

    public String ip() {
        return this.ip;
    }

    public String url() {
        return this.url;
    }

    public Performance performance() {
        return this.performance;
    }

    public List<Integer> usedPorts() {
        return this.usedPorts;
    }

    public Integer usedPorts(int index) {
        return this.usedPorts.get(index);
    }

    public List<Integer> usedPorts(Predicate<Integer> predicate) {
        return this.usedPorts().stream().filter(predicate).collect(Collectors.toList());
    }

    public int reservePort() {
        return this.reservePort.reservePort();
    }

    public void releasePort(int port) {
        this.releasePort.release(port);
    }

    public boolean isDisconnected() {
        return (Boolean)this.isDisconnected.value();
    }

    public ServerDigest status() {
        return this.status;
    }

    @Override
    public String label() {
        return this._metaType.label();
    }

    public Server ip(String value) {
        this.ip = value;
        return this;
    }

    public Server url(String value) {
        this.url = value;
        return this;
    }

    public Server performance(Performance value) {
        this.performance = value;
        return this;
    }

    public Server reservePort(PortReservation value) {
        this.reservePort = (PortReservation)FunctionLoader.load((Object)this.reservePort, (Layer)this, PortReservation.class);
        return this;
    }

    public Server releasePort(PortRelease value) {
        this.releasePort = (PortRelease)FunctionLoader.load((Object)this.releasePort, (Layer)this, PortRelease.class);
        return this;
    }

    public Server isDisconnected(Expression<Boolean> value) {
        this.isDisconnected = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
        return this;
    }

    public Server status(ServerDigest value) {
        this.status = value;
        return this;
    }

    @Override
    public Server label(String value) {
        this._metaType.label(value);
        return this;
    }

    public ServerConsul serverConsul() {
        return this.serverConsul;
    }

    public RemoteConnection remoteConnection() {
        return this.remoteConnection;
    }

    public Memory memory() {
        return this.memory;
    }

    public CPU cPU() {
        return this.cPU;
    }

    public HDD hDD() {
        return this.hDD;
    }

    public Server serverConsul(ServerConsul value) {
        this.serverConsul = value;
        return this;
    }

    public Server remoteConnection(RemoteConnection value) {
        this.remoteConnection = value;
        return this;
    }

    public Server memory(Memory value) {
        this.memory = value;
        return this;
    }

    public Server cPU(CPU value) {
        this.cPU = value;
        return this;
    }

    public Server hDD(HDD value) {
        this.hDD = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.serverConsul != null) {
            components.add(this.serverConsul.core$());
        }
        if (this.remoteConnection != null) {
            components.add(this.remoteConnection.core$());
        }
        if (this.memory != null) {
            components.add(this.memory.core$());
        }
        if (this.cPU != null) {
            components.add(this.cPU.core$());
        }
        if (this.hDD != null) {
            components.add(this.hDD.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("sensors", this.sensors);
        map.put("active", this.active);
        map.put("ip", new ArrayList<String>(Collections.singletonList(this.ip)));
        map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
        map.put("performance", new ArrayList<Performance>(Collections.singletonList(this.performance)));
        map.put("usedPorts", this.usedPorts);
        map.put("reservePort", this.reservePort != null ? new ArrayList<PortReservation>(Collections.singletonList(this.reservePort)) : Collections.emptyList());
        map.put("releasePort", this.releasePort != null ? new ArrayList<PortRelease>(Collections.singletonList(this.releasePort)) : Collections.emptyList());
        map.put("isDisconnected", new ArrayList<Expression<Boolean>>(Collections.singletonList(this.isDisconnected)));
        map.put("status", new ArrayList<ServerDigest>(Collections.singletonList(this.status)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("ServerConsul")) {
            this.serverConsul = (ServerConsul)node.as(ServerConsul.class);
        }
        if (node.is("Server$RemoteConnection")) {
            this.remoteConnection = (RemoteConnection)node.as(RemoteConnection.class);
        }
        if (node.is("Memory")) {
            this.memory = (Memory)node.as(Memory.class);
        }
        if (node.is("CPU")) {
            this.cPU = (CPU)node.as(CPU.class);
        }
        if (node.is("HDD")) {
            this.hDD = (HDD)node.as(HDD.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("ServerConsul")) {
            this.serverConsul = null;
        }
        if (node.is("Server$RemoteConnection")) {
            this.remoteConnection = null;
        }
        if (node.is("Memory")) {
            this.memory = null;
        }
        if (node.is("CPU")) {
            this.cPU = null;
        }
        if (node.is("HDD")) {
            this.hDD = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("sensors")) {
            this.sensors = WordLoader.load(values, Sensors.class, (Layer)this);
        } else if (name.equalsIgnoreCase("active")) {
            this.active = WordLoader.load(values, Active.class, (Layer)this);
        } else if (name.equalsIgnoreCase("ip")) {
            this.ip = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("url")) {
            this.url = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("performance")) {
            this.performance = (Performance)((Object)WordLoader.load(values, Performance.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("usedPorts")) {
            this.usedPorts = IntegerLoader.load(values, (Layer)this);
        } else if (name.equalsIgnoreCase("reservePort")) {
            this.reservePort = (PortReservation)FunctionLoader.load(values, (Layer)this, PortReservation.class).get(0);
        } else if (name.equalsIgnoreCase("releasePort")) {
            this.releasePort = (PortRelease)FunctionLoader.load(values, (Layer)this, PortRelease.class).get(0);
        } else if (name.equalsIgnoreCase("isDisconnected")) {
            this.isDisconnected = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        } else if (name.equalsIgnoreCase("status")) {
            this.status = (ServerDigest)ObjectLoader.load(values, ServerDigest.class, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("sensors")) {
            this.sensors = new ArrayList(values);
        } else if (name.equalsIgnoreCase("active")) {
            this.active = new ArrayList(values);
        } else if (name.equalsIgnoreCase("ip")) {
            this.ip = (String)values.get(0);
        } else if (name.equalsIgnoreCase("url")) {
            this.url = (String)values.get(0);
        } else if (name.equalsIgnoreCase("performance")) {
            this.performance = (Performance)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("usedPorts")) {
            this.usedPorts = new ArrayList(values);
        } else if (name.equalsIgnoreCase("reservePort")) {
            this.reservePort = (PortReservation)FunctionLoader.load(values.get(0), (Layer)this, PortReservation.class);
        } else if (name.equalsIgnoreCase("releasePort")) {
            this.releasePort = (PortRelease)FunctionLoader.load(values.get(0), (Layer)this, PortRelease.class);
        } else if (name.equalsIgnoreCase("isDisconnected")) {
            this.isDisconnected = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        } else if (name.equalsIgnoreCase("status")) {
            this.status = (ServerDigest)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public static class RemoteConnection
    extends Layer
    implements Terminal {
        protected String user;
        protected String url;
        protected int port;
        protected Entity _metaType = (Entity)this.core$().as(Entity.class);

        public RemoteConnection(Node node) {
            super(node);
        }

        public String user() {
            return this.user;
        }

        public String url() {
            return this.url;
        }

        public int port() {
            return this.port;
        }

        public String label() {
            return this._metaType.label();
        }

        public RemoteConnection user(String value) {
            this.user = value;
            return this;
        }

        public RemoteConnection url(String value) {
            this.url = value;
            return this;
        }

        public RemoteConnection port(int value) {
            this.port = value;
            return this;
        }

        public RemoteConnection label(String value) {
            this._metaType.label(value);
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
            map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
            map.put("port", new ArrayList<Integer>(Collections.singletonList(this.port)));
            map.put("label", new ArrayList<String>(Collections.singletonList(this._metaType.label())));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this.core$().load((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("user")) {
                this.user = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("url")) {
                this.url = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this.core$().set((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("user")) {
                this.user = (String)values.get(0);
            } else if (name.equalsIgnoreCase("url")) {
                this.url = (String)values.get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (Integer)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear
    extends Unit.Clear {
        public Clear() {
            super(Server.this);
        }
    }

    public class Create
    extends Unit.Create {
        public Create(String name) {
            super(Server.this, name);
        }

        public ServerConsul serverConsul(String version) {
            ServerConsul newElement = (ServerConsul)Server.this.core$().graph().concept(ServerConsul.class).createNode(this.name, Server.this.core$()).as(ServerConsul.class);
            newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public RemoteConnection remoteConnection(String user, String url, int port) {
            RemoteConnection newElement = (RemoteConnection)Server.this.core$().graph().concept(RemoteConnection.class).createNode(this.name, Server.this.core$()).as(RemoteConnection.class);
            newElement.core$().set((Layer)newElement, "user", Collections.singletonList(user));
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            newElement.core$().set((Layer)newElement, "port", Collections.singletonList(port));
            return newElement;
        }

        public Memory memory(double capacity) {
            Memory newElement = (Memory)Server.this.core$().graph().concept(Memory.class).createNode(this.name, Server.this.core$()).as(Memory.class);
            newElement.core$().set((Layer)newElement, "capacity", Collections.singletonList(capacity));
            return newElement;
        }

        public CPU cPU(int cores, double frequency) {
            CPU newElement = (CPU)Server.this.core$().graph().concept(CPU.class).createNode(this.name, Server.this.core$()).as(CPU.class);
            newElement.core$().set((Layer)newElement, "cores", Collections.singletonList(cores));
            newElement.core$().set((Layer)newElement, "frequency", Collections.singletonList(frequency));
            return newElement;
        }

        public HDD hDD(int frequency, double capacity) {
            HDD newElement = (HDD)Server.this.core$().graph().concept(HDD.class).createNode(this.name, Server.this.core$()).as(HDD.class);
            newElement.core$().set((Layer)newElement, "frequency", Collections.singletonList(frequency));
            newElement.core$().set((Layer)newElement, "capacity", Collections.singletonList(capacity));
            return newElement;
        }
    }

    public static enum Performance {
        High,
        Medium,
        Low;

    }

    public static enum Active {
        limitedHardDisk,
        LimitedMemory,
        LimitedCPU,
        disconnected;

    }

    public static enum Sensors {
        limitedHardDisk,
        LimitedMemory,
        LimitedCPU,
        disconnected;

    }
}

