/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Consul;
import io.intino.cesar.graph.DeviceDigest;
import io.intino.cesar.graph.Unit;
import io.intino.cesar.graph.functions.Update;
import io.intino.sumus.graph.Entity;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.ObjectLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class Device
extends Unit
implements Component,
Terminal {
    protected List<Sensors> sensors = new ArrayList<Sensors>();
    protected List<Active> active = new ArrayList<Active>();
    protected boolean compromised;
    protected Update updateTemperatureRange;
    protected DeviceDigest status;
    protected Consul consul;
    protected Screen screen;
    protected Temperature temperature;

    public Device(Node node) {
        super(node);
    }

    public List<Sensors> sensors() {
        return this.sensors;
    }

    public List<Active> active() {
        return this.active;
    }

    public boolean compromised() {
        return this.compromised;
    }

    public void updateTemperatureRange() {
        this.updateTemperatureRange.update();
    }

    public DeviceDigest status() {
        return this.status;
    }

    @Override
    public String label() {
        return this._metaType.label();
    }

    public Device compromised(boolean value) {
        this.compromised = value;
        return this;
    }

    public Device updateTemperatureRange(Update value) {
        this.updateTemperatureRange = (Update)FunctionLoader.load((Object)this.updateTemperatureRange, (Layer)this, Update.class);
        return this;
    }

    public Device status(DeviceDigest value) {
        this.status = value;
        return this;
    }

    @Override
    public Device label(String value) {
        this._metaType.label(value);
        return this;
    }

    public Consul consul() {
        return this.consul;
    }

    public Screen screen() {
        return this.screen;
    }

    public Temperature temperature() {
        return this.temperature;
    }

    public Device consul(Consul value) {
        this.consul = value;
        return this;
    }

    public Device screen(Screen value) {
        this.screen = value;
        return this;
    }

    public Device temperature(Temperature value) {
        this.temperature = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.consul != null) {
            components.add(this.consul.core$());
        }
        if (this.screen != null) {
            components.add(this.screen.core$());
        }
        if (this.temperature != null) {
            components.add(this.temperature.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("sensors", this.sensors);
        map.put("active", this.active);
        map.put("compromised", new ArrayList<Boolean>(Collections.singletonList(this.compromised)));
        map.put("updateTemperatureRange", this.updateTemperatureRange != null ? new ArrayList<Update>(Collections.singletonList(this.updateTemperatureRange)) : Collections.emptyList());
        map.put("status", new ArrayList<DeviceDigest>(Collections.singletonList(this.status)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Consul")) {
            this.consul = (Consul)node.as(Consul.class);
        }
        if (node.is("Device$Screen")) {
            this.screen = (Screen)node.as(Screen.class);
        }
        if (node.is("Device$Temperature")) {
            this.temperature = (Temperature)node.as(Temperature.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Consul")) {
            this.consul = null;
        }
        if (node.is("Device$Screen")) {
            this.screen = null;
        }
        if (node.is("Device$Temperature")) {
            this.temperature = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("sensors")) {
            this.sensors = WordLoader.load(values, Sensors.class, (Layer)this);
        } else if (name.equalsIgnoreCase("active")) {
            this.active = WordLoader.load(values, Active.class, (Layer)this);
        } else if (name.equalsIgnoreCase("compromised")) {
            this.compromised = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("updateTemperatureRange")) {
            this.updateTemperatureRange = (Update)FunctionLoader.load(values, (Layer)this, Update.class).get(0);
        } else if (name.equalsIgnoreCase("status")) {
            this.status = (DeviceDigest)ObjectLoader.load(values, DeviceDigest.class, (Layer)this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("sensors")) {
            this.sensors = new ArrayList(values);
        } else if (name.equalsIgnoreCase("active")) {
            this.active = new ArrayList(values);
        } else if (name.equalsIgnoreCase("compromised")) {
            this.compromised = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("updateTemperatureRange")) {
            this.updateTemperatureRange = (Update)FunctionLoader.load(values.get(0), (Layer)this, Update.class);
        } else if (name.equalsIgnoreCase("status")) {
            this.status = (DeviceDigest)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public static class Temperature
    extends Layer
    implements Terminal {
        protected double min;
        protected double max;
        protected Entity _metaType = (Entity)this.core$().as(Entity.class);

        public Temperature(Node node) {
            super(node);
        }

        public double min() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public String label() {
            return this._metaType.label();
        }

        public Temperature min(double value) {
            this.min = value;
            return this;
        }

        public Temperature max(double value) {
            this.max = value;
            return this;
        }

        public Temperature label(String value) {
            this._metaType.label(value);
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("min", new ArrayList<Double>(Collections.singletonList(this.min)));
            map.put("max", new ArrayList<Double>(Collections.singletonList(this.max)));
            map.put("label", new ArrayList<String>(Collections.singletonList(this._metaType.label())));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this.core$().load((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("min")) {
                this.min = (Double)DoubleLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Double)DoubleLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this.core$().set((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("min")) {
                this.min = (Double)values.get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Double)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Screen
    extends Layer
    implements Terminal {
        protected int width;
        protected int height;
        protected Entity _metaType = (Entity)this.core$().as(Entity.class);

        public Screen(Node node) {
            super(node);
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public String label() {
            return this._metaType.label();
        }

        public Screen width(int value) {
            this.width = value;
            return this;
        }

        public Screen height(int value) {
            this.height = value;
            return this;
        }

        public Screen label(String value) {
            this._metaType.label(value);
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            map.put("label", new ArrayList<String>(Collections.singletonList(this._metaType.label())));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this.core$().load((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this.core$().set((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear
    extends Unit.Clear {
        public Clear() {
            super(Device.this);
        }
    }

    public class Create
    extends Unit.Create {
        public Create(String name) {
            super(Device.this, name);
        }

        public Consul consul(String version) {
            Consul newElement = (Consul)Device.this.core$().graph().concept(Consul.class).createNode(this.name, Device.this.core$()).as(Consul.class);
            newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Screen screen(String label) {
            Screen newElement = (Screen)Device.this.core$().graph().concept(Screen.class).createNode(this.name, Device.this.core$()).as(Screen.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Temperature temperature(double min, double max, String label) {
            Temperature newElement = (Temperature)Device.this.core$().graph().concept(Temperature.class).createNode(this.name, Device.this.core$()).as(Temperature.class);
            newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
            newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }
    }

    public static enum Active {
        unplugged,
        highTemperature,
        lowBattery,
        veryLowBattery,
        disconnected,
        misconfigured;

    }

    public static enum Sensors {
        unplugged,
        highTemperature,
        lowBattery,
        veryLowBattery,
        disconnected,
        misconfigured;

    }
}

