/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.CesarGraph;
import io.intino.sumus.graph.Entity;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Artifact
extends Layer
implements Component,
Terminal {
    protected String group;
    protected String artifactId;
    protected String version;
    protected String classpathPrefix;
    protected List<Artifactory> artifactoryList = new ArrayList<Artifactory>();
    protected Entity _metaType = (Entity)this.core$().as(Entity.class);

    public Artifact(Node node) {
        super(node);
    }

    public String group() {
        return this.group;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String version() {
        return this.version;
    }

    public String classpathPrefix() {
        return this.classpathPrefix;
    }

    public String label() {
        return this._metaType.label();
    }

    public Artifact group(String value) {
        this.group = value;
        return this;
    }

    public Artifact artifactId(String value) {
        this.artifactId = value;
        return this;
    }

    public Artifact version(String value) {
        this.version = value;
        return this;
    }

    public Artifact classpathPrefix(String value) {
        this.classpathPrefix = value;
        return this;
    }

    public Artifact label(String value) {
        this._metaType.label(value);
        return this;
    }

    public List<Artifactory> artifactoryList() {
        return Collections.unmodifiableList(this.artifactoryList);
    }

    public Artifactory artifactory(int index) {
        return this.artifactoryList.get(index);
    }

    public List<Artifactory> artifactoryList(Predicate<Artifactory> predicate) {
        return this.artifactoryList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        this.artifactoryList.stream().forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("group", new ArrayList<String>(Collections.singletonList(this.group)));
        map.put("artifactId", new ArrayList<String>(Collections.singletonList(this.artifactId)));
        map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
        map.put("classpathPrefix", new ArrayList<String>(Collections.singletonList(this.classpathPrefix)));
        map.put("label", new ArrayList<String>(Collections.singletonList(this._metaType.label())));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Artifact$Artifactory")) {
            this.artifactoryList.add((Artifactory)node.as(Artifactory.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Artifact$Artifactory")) {
            this.artifactoryList.remove(node.as(Artifactory.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        this.core$().load((Layer)this._metaType, name, values);
        if (name.equalsIgnoreCase("group")) {
            this.group = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("artifactId")) {
            this.artifactId = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("version")) {
            this.version = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("classpathPrefix")) {
            this.classpathPrefix = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        this.core$().set((Layer)this._metaType, name, values);
        if (name.equalsIgnoreCase("group")) {
            this.group = (String)values.get(0);
        } else if (name.equalsIgnoreCase("artifactId")) {
            this.artifactId = (String)values.get(0);
        } else if (name.equalsIgnoreCase("version")) {
            this.version = (String)values.get(0);
        } else if (name.equalsIgnoreCase("classpathPrefix")) {
            this.classpathPrefix = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public CesarGraph graph() {
        return (CesarGraph)this.core$().graph().as(CesarGraph.class);
    }

    public static class Artifactory
    extends Layer
    implements Terminal {
        protected String url;
        protected String mavenId;
        protected List<Authentication> authenticationList = new ArrayList<Authentication>();
        protected Entity _metaType = (Entity)this.core$().as(Entity.class);

        public Artifactory(Node node) {
            super(node);
        }

        public String url() {
            return this.url;
        }

        public String mavenId() {
            return this.mavenId;
        }

        public String label() {
            return this._metaType.label();
        }

        public Artifactory url(String value) {
            this.url = value;
            return this;
        }

        public Artifactory mavenId(String value) {
            this.mavenId = value;
            return this;
        }

        public Artifactory label(String value) {
            this._metaType.label(value);
            return this;
        }

        public List<Authentication> authenticationList() {
            return Collections.unmodifiableList(this.authenticationList);
        }

        public Authentication authentication(int index) {
            return this.authenticationList.get(index);
        }

        public List<Authentication> authenticationList(Predicate<Authentication> predicate) {
            return this.authenticationList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            this.authenticationList.stream().forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
            map.put("mavenId", new ArrayList<String>(Collections.singletonList(this.mavenId)));
            map.put("label", new ArrayList<String>(Collections.singletonList(this._metaType.label())));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Artifact$Artifactory$Authentication")) {
                this.authenticationList.add((Authentication)node.as(Authentication.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Artifact$Artifactory$Authentication")) {
                this.authenticationList.remove(node.as(Authentication.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            this.core$().load((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("url")) {
                this.url = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("mavenId")) {
                this.mavenId = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            this.core$().set((Layer)this._metaType, name, values);
            if (name.equalsIgnoreCase("url")) {
                this.url = (String)values.get(0);
            } else if (name.equalsIgnoreCase("mavenId")) {
                this.mavenId = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public CesarGraph graph() {
            return (CesarGraph)this.core$().graph().as(CesarGraph.class);
        }

        public static class Authentication
        extends Layer
        implements Terminal {
            protected String user;
            protected String password;
            protected Entity _metaType = (Entity)this.core$().as(Entity.class);

            public Authentication(Node node) {
                super(node);
            }

            public String user() {
                return this.user;
            }

            public String password() {
                return this.password;
            }

            public String label() {
                return this._metaType.label();
            }

            public Authentication user(String value) {
                this.user = value;
                return this;
            }

            public Authentication password(String value) {
                this.password = value;
                return this;
            }

            public Authentication label(String value) {
                this._metaType.label(value);
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
                map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
                map.put("label", new ArrayList<String>(Collections.singletonList(this._metaType.label())));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this.core$().load((Layer)this._metaType, name, values);
                if (name.equalsIgnoreCase("user")) {
                    this.user = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("password")) {
                    this.password = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this.core$().set((Layer)this._metaType, name, values);
                if (name.equalsIgnoreCase("user")) {
                    this.user = (String)values.get(0);
                } else if (name.equalsIgnoreCase("password")) {
                    this.password = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public CesarGraph graph() {
                return (CesarGraph)this.core$().graph().as(CesarGraph.class);
            }

            public class Clear {
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Clear {
            public void authentication(Predicate<Authentication> ... filters) {
                new ArrayList<Authentication>(Artifactory.this.authenticationList()).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Authentication authentication(String user, String password) {
                Authentication newElement = (Authentication)Artifactory.this.core$().graph().concept(Authentication.class).createNode(this.name, Artifactory.this.core$()).as(Authentication.class);
                newElement.core$().set((Layer)newElement, "user", Collections.singletonList(user));
                newElement.core$().set((Layer)newElement, "password", Collections.singletonList(password));
                return newElement;
            }
        }
    }

    public class Clear {
        public void artifactory(Predicate<Artifactory> ... filters) {
            new ArrayList<Artifactory>(Artifact.this.artifactoryList()).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Artifactory artifactory(String url, String mavenId) {
            Artifactory newElement = (Artifactory)Artifact.this.core$().graph().concept(Artifactory.class).createNode(this.name, Artifact.this.core$()).as(Artifactory.class);
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            newElement.core$().set((Layer)newElement, "mavenId", Collections.singletonList(mavenId));
            return newElement;
        }
    }
}

