/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.graph;

import io.intino.cesar.graph.Configuration;
import io.intino.cesar.graph.Consul;
import io.intino.cesar.graph.Deploy;
import io.intino.cesar.graph.Identifiable;
import io.intino.cesar.graph.Infrastructure;
import io.intino.cesar.graph.Monitor;
import io.intino.cesar.graph.Move;
import io.intino.cesar.graph.Operation;
import io.intino.cesar.graph.Responsible;
import io.intino.cesar.graph.ShutDown;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.emailcontact.EmailContactResponsible;
import io.intino.cesar.graph.slackcontact.SlackContactResponsible;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Metric;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.Ticket;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.utils.I18n;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private Infrastructure infrastructure;
    private List<System> systemList;
    private List<Consul> consulList;
    private List<Identifiable> identifiableList;
    private List<Responsible> responsibleList;
    private List<EmailContactResponsible> emailContactResponsibleList;
    private List<SlackContactResponsible> slackContactResponsibleList;
    private Configuration configuration;
    private Olap cesarOlap;
    private Ticket meanTemperatureTicket;
    private Metric temperature;
    private Metric amount;
    private Cube deviceCube;
    private Cube serverCube;
    private Cube systemCube;
    private Catalog countryCatalog;
    private NameSpace default$;
    private List<Operation> operationList;
    private List<Deploy> deployList;
    private List<ShutDown> shutDownList;
    private List<Move> moveList;
    private List<Monitor> monitorList;

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Cesar");
    }

    public void update() {
        List default$List;
        List countryCatalogList;
        List systemCubeList;
        List serverCubeList;
        List deviceCubeList;
        List amountList;
        List temperatureList;
        List meanTemperatureTicketList;
        this.infrastructure = this.graph.rootList(Infrastructure.class).stream().findFirst().orElse(null);
        this.systemList = this.graph.rootList(System.class);
        this.consulList = this.graph.rootList(Consul.class);
        this.identifiableList = this.graph.rootList(Identifiable.class);
        this.responsibleList = this.graph.rootList(Responsible.class);
        this.emailContactResponsibleList = this.graph.rootList(EmailContactResponsible.class);
        this.slackContactResponsibleList = this.graph.rootList(SlackContactResponsible.class);
        this.configuration = this.graph.rootList(Configuration.class).stream().findFirst().orElse(null);
        List cesarOlapList = this.graph.rootList(r -> r.id().equals("Cesar#cesarOlap"));
        if (!cesarOlapList.isEmpty()) {
            this.cesarOlap = (Olap)((Node)cesarOlapList.get(0)).as(Olap.class);
        }
        if (!(meanTemperatureTicketList = this.graph.rootList(r -> r.id().equals("Cesar#meanTemperatureTicket"))).isEmpty()) {
            this.meanTemperatureTicket = (Ticket)((Node)meanTemperatureTicketList.get(0)).as(Ticket.class);
        }
        if (!(temperatureList = this.graph.rootList(r -> r.id().equals("Cesar#temperature"))).isEmpty()) {
            this.temperature = (Metric)((Node)temperatureList.get(0)).as(Metric.class);
        }
        if (!(amountList = this.graph.rootList(r -> r.id().equals("Cesar#amount"))).isEmpty()) {
            this.amount = (Metric)((Node)amountList.get(0)).as(Metric.class);
        }
        if (!(deviceCubeList = this.graph.rootList(r -> r.id().equals("Cesar#DeviceCube"))).isEmpty()) {
            this.deviceCube = (Cube)((Node)deviceCubeList.get(0)).as(Cube.class);
        }
        if (!(serverCubeList = this.graph.rootList(r -> r.id().equals("Cesar#ServerCube"))).isEmpty()) {
            this.serverCube = (Cube)((Node)serverCubeList.get(0)).as(Cube.class);
        }
        if (!(systemCubeList = this.graph.rootList(r -> r.id().equals("Cesar#SystemCube"))).isEmpty()) {
            this.systemCube = (Cube)((Node)systemCubeList.get(0)).as(Cube.class);
        }
        if (!(countryCatalogList = this.graph.rootList(r -> r.id().equals("Cesar#countryCatalog"))).isEmpty()) {
            this.countryCatalog = (Catalog)((Node)countryCatalogList.get(0)).as(Catalog.class);
        }
        if (!(default$List = this.graph.rootList(r -> r.id().equals("Cesar#default"))).isEmpty()) {
            this.default$ = (NameSpace)((Node)default$List.get(0)).as(NameSpace.class);
        }
        this.operationList = this.graph.rootList(Operation.class);
        this.deployList = this.graph.rootList(Deploy.class);
        this.shutDownList = this.graph.rootList(ShutDown.class);
        this.moveList = this.graph.rootList(Move.class);
        this.monitorList = this.graph.rootList(Monitor.class);
    }

    protected void addNode$(Node node) {
        if (node.is("Infrastructure")) {
            this.infrastructure = (Infrastructure)node.as(Infrastructure.class);
        }
        if (node.is("System")) {
            this.systemList.add((System)node.as(System.class));
        }
        if (node.is("Consul")) {
            this.consulList.add((Consul)node.as(Consul.class));
        }
        if (node.is("Identifiable")) {
            this.identifiableList.add((Identifiable)node.as(Identifiable.class));
        }
        if (node.is("Responsible")) {
            this.responsibleList.add((Responsible)node.as(Responsible.class));
        }
        if (node.is("EmailContact#Responsible")) {
            this.emailContactResponsibleList.add((EmailContactResponsible)node.as(EmailContactResponsible.class));
        }
        if (node.is("SlackContact#Responsible")) {
            this.slackContactResponsibleList.add((SlackContactResponsible)node.as(SlackContactResponsible.class));
        }
        if (node.is("Configuration")) {
            this.configuration = (Configuration)node.as(Configuration.class);
        }
        if (node.id().equals("Cesar#cesarOlap")) {
            this.cesarOlap = (Olap)node.as(Olap.class);
        }
        if (node.id().equals("Cesar#meanTemperatureTicket")) {
            this.meanTemperatureTicket = (Ticket)node.as(Ticket.class);
        }
        if (node.id().equals("Cesar#temperature")) {
            this.temperature = (Metric)node.as(Metric.class);
        }
        if (node.id().equals("Cesar#amount")) {
            this.amount = (Metric)node.as(Metric.class);
        }
        if (node.id().equals("Cesar#DeviceCube")) {
            this.deviceCube = (Cube)node.as(Cube.class);
        }
        if (node.id().equals("Cesar#ServerCube")) {
            this.serverCube = (Cube)node.as(Cube.class);
        }
        if (node.id().equals("Cesar#SystemCube")) {
            this.systemCube = (Cube)node.as(Cube.class);
        }
        if (node.id().equals("Cesar#countryCatalog")) {
            this.countryCatalog = (Catalog)node.as(Catalog.class);
        }
        if (node.id().equals("Cesar#default")) {
            this.default$ = (NameSpace)node.as(NameSpace.class);
        }
        if (node.is("Operation")) {
            this.operationList.add((Operation)node.as(Operation.class));
        }
        if (node.is("Deploy")) {
            this.deployList.add((Deploy)node.as(Deploy.class));
        }
        if (node.is("ShutDown")) {
            this.shutDownList.add((ShutDown)node.as(ShutDown.class));
        }
        if (node.is("Move")) {
            this.moveList.add((Move)node.as(Move.class));
        }
        if (node.is("Monitor")) {
            this.monitorList.add((Monitor)node.as(Monitor.class));
        }
    }

    protected void removeNode$(Node node) {
        if (node.is("Infrastructure")) {
            this.infrastructure = null;
        }
        if (node.is("System")) {
            this.systemList.remove(node.as(System.class));
        }
        if (node.is("Consul")) {
            this.consulList.remove(node.as(Consul.class));
        }
        if (node.is("Identifiable")) {
            this.identifiableList.remove(node.as(Identifiable.class));
        }
        if (node.is("Responsible")) {
            this.responsibleList.remove(node.as(Responsible.class));
        }
        if (node.is("EmailContact#Responsible")) {
            this.emailContactResponsibleList.remove(node.as(EmailContactResponsible.class));
        }
        if (node.is("SlackContact#Responsible")) {
            this.slackContactResponsibleList.remove(node.as(SlackContactResponsible.class));
        }
        if (node.is("Configuration")) {
            this.configuration = null;
        }
        if (node.id().equals("Cesar#cesarOlap")) {
            this.cesarOlap = null;
        }
        if (node.id().equals("Cesar#meanTemperatureTicket")) {
            this.meanTemperatureTicket = null;
        }
        if (node.id().equals("Cesar#temperature")) {
            this.temperature = null;
        }
        if (node.id().equals("Cesar#amount")) {
            this.amount = null;
        }
        if (node.id().equals("Cesar#DeviceCube")) {
            this.deviceCube = null;
        }
        if (node.id().equals("Cesar#ServerCube")) {
            this.serverCube = null;
        }
        if (node.id().equals("Cesar#SystemCube")) {
            this.systemCube = null;
        }
        if (node.id().equals("Cesar#countryCatalog")) {
            this.countryCatalog = null;
        }
        if (node.id().equals("Cesar#default")) {
            this.default$ = null;
        }
        if (node.is("Operation")) {
            this.operationList.remove(node.as(Operation.class));
        }
        if (node.is("Deploy")) {
            this.deployList.remove(node.as(Deploy.class));
        }
        if (node.is("ShutDown")) {
            this.shutDownList.remove(node.as(ShutDown.class));
        }
        if (node.is("Move")) {
            this.moveList.remove(node.as(Move.class));
        }
        if (node.is("Monitor")) {
            this.monitorList.remove(node.as(Monitor.class));
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public Infrastructure infrastructure() {
        return this.infrastructure;
    }

    public List<System> systemList() {
        return this.systemList;
    }

    public List<Consul> consulList() {
        return this.consulList;
    }

    public List<Identifiable> identifiableList() {
        return this.identifiableList;
    }

    public List<Responsible> responsibleList() {
        return this.responsibleList;
    }

    public List<EmailContactResponsible> emailContactResponsibleList() {
        return this.emailContactResponsibleList;
    }

    public List<SlackContactResponsible> slackContactResponsibleList() {
        return this.slackContactResponsibleList;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Olap cesarOlap() {
        return this.cesarOlap;
    }

    public Ticket meanTemperatureTicket() {
        return this.meanTemperatureTicket;
    }

    public Metric temperature() {
        return this.temperature;
    }

    public Metric amount() {
        return this.amount;
    }

    public Cube deviceCube() {
        return this.deviceCube;
    }

    public Cube serverCube() {
        return this.serverCube;
    }

    public Cube systemCube() {
        return this.systemCube;
    }

    public Catalog countryCatalog() {
        return this.countryCatalog;
    }

    public NameSpace default$() {
        return this.default$;
    }

    public List<Operation> operationList() {
        return this.operationList;
    }

    public List<Deploy> deployList() {
        return this.deployList;
    }

    public List<ShutDown> shutDownList() {
        return this.shutDownList;
    }

    public List<Move> moveList() {
        return this.moveList;
    }

    public List<Monitor> monitorList() {
        return this.monitorList;
    }

    public Stream<System> systemList(Predicate<System> filter) {
        return this.systemList.stream().filter(filter);
    }

    public System system(int index) {
        return this.systemList.get(index);
    }

    public Stream<Consul> consulList(Predicate<Consul> filter) {
        return this.consulList.stream().filter(filter);
    }

    public Consul consul(int index) {
        return this.consulList.get(index);
    }

    public Stream<Identifiable> identifiableList(Predicate<Identifiable> filter) {
        return this.identifiableList.stream().filter(filter);
    }

    public Identifiable identifiable(int index) {
        return this.identifiableList.get(index);
    }

    public Stream<Responsible> responsibleList(Predicate<Responsible> filter) {
        return this.responsibleList.stream().filter(filter);
    }

    public Responsible responsible(int index) {
        return this.responsibleList.get(index);
    }

    public Stream<EmailContactResponsible> emailContactResponsibleList(Predicate<EmailContactResponsible> filter) {
        return this.emailContactResponsibleList.stream().filter(filter);
    }

    public EmailContactResponsible emailContactResponsible(int index) {
        return this.emailContactResponsibleList.get(index);
    }

    public Stream<SlackContactResponsible> slackContactResponsibleList(Predicate<SlackContactResponsible> filter) {
        return this.slackContactResponsibleList.stream().filter(filter);
    }

    public SlackContactResponsible slackContactResponsible(int index) {
        return this.slackContactResponsibleList.get(index);
    }

    public Stream<Operation> operationList(Predicate<Operation> filter) {
        return this.operationList.stream().filter(filter);
    }

    public Operation operation(int index) {
        return this.operationList.get(index);
    }

    public Stream<Deploy> deployList(Predicate<Deploy> filter) {
        return this.deployList.stream().filter(filter);
    }

    public Deploy deploy(int index) {
        return this.deployList.get(index);
    }

    public Stream<ShutDown> shutDownList(Predicate<ShutDown> filter) {
        return this.shutDownList.stream().filter(filter);
    }

    public ShutDown shutDown(int index) {
        return this.shutDownList.get(index);
    }

    public Stream<Move> moveList(Predicate<Move> filter) {
        return this.moveList.stream().filter(filter);
    }

    public Move move(int index) {
        return this.moveList.get(index);
    }

    public Stream<Monitor> monitorList(Predicate<Monitor> filter) {
        return this.monitorList.stream().filter(filter);
    }

    public Monitor monitor(int index) {
        return this.monitorList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    public class Clear {
        public void system(Predicate<System> ... filters) {
            new ArrayList<System>(AbstractGraph.this.systemList()).forEach(Layer::delete$);
        }

        public void consul(Predicate<Consul> ... filters) {
            new ArrayList<Consul>(AbstractGraph.this.consulList()).forEach(Layer::delete$);
        }

        public void responsible(Predicate<Responsible> ... filters) {
            new ArrayList<Responsible>(AbstractGraph.this.responsibleList()).forEach(Layer::delete$);
        }

        public void emailContactResponsible(Predicate<EmailContactResponsible> ... filters) {
            new ArrayList<EmailContactResponsible>(AbstractGraph.this.emailContactResponsibleList()).forEach(Layer::delete$);
        }

        public void slackContactResponsible(Predicate<SlackContactResponsible> ... filters) {
            new ArrayList<SlackContactResponsible>(AbstractGraph.this.slackContactResponsibleList()).forEach(Layer::delete$);
        }

        public void operation(Predicate<Operation> ... filters) {
            new ArrayList<Operation>(AbstractGraph.this.operationList()).forEach(Layer::delete$);
        }

        public void deploy(Predicate<Deploy> ... filters) {
            new ArrayList<Deploy>(AbstractGraph.this.deployList()).forEach(Layer::delete$);
        }

        public void shutDown(Predicate<ShutDown> ... filters) {
            new ArrayList<ShutDown>(AbstractGraph.this.shutDownList()).forEach(Layer::delete$);
        }

        public void move(Predicate<Move> ... filters) {
            new ArrayList<Move>(AbstractGraph.this.moveList()).forEach(Layer::delete$);
        }

        public void monitor(Predicate<Monitor> ... filters) {
            new ArrayList<Monitor>(AbstractGraph.this.monitorList()).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Infrastructure infrastructure() {
            Infrastructure newElement = (Infrastructure)((Infrastructure)AbstractGraph.this.graph.createRoot(Infrastructure.class, this.stash, this.name)).core$().as(Infrastructure.class);
            return newElement;
        }

        public System system(String alias, String url) {
            System newElement = (System)((System)AbstractGraph.this.graph.createRoot(System.class, this.stash, this.name)).core$().as(System.class);
            newElement.core$().set((Layer)newElement, "alias", Collections.singletonList(alias));
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            return newElement;
        }

        public Consul consul(String version) {
            Consul newElement = (Consul)((Consul)AbstractGraph.this.graph.createRoot(Consul.class, this.stash, this.name)).core$().as(Consul.class);
            newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Responsible responsible(String username, String label) {
            Responsible newElement = (Responsible)((Responsible)AbstractGraph.this.graph.createRoot(Responsible.class, this.stash, this.name)).core$().as(Responsible.class);
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public EmailContactResponsible emailContactResponsible(String email) {
            EmailContactResponsible newElement = (EmailContactResponsible)((EmailContactResponsible)AbstractGraph.this.graph.createRoot(EmailContactResponsible.class, this.stash, this.name)).core$().as(EmailContactResponsible.class);
            newElement.core$().set((Layer)newElement, "email", Collections.singletonList(email));
            return newElement;
        }

        public SlackContactResponsible slackContactResponsible(String slackChannel) {
            SlackContactResponsible newElement = (SlackContactResponsible)((SlackContactResponsible)AbstractGraph.this.graph.createRoot(SlackContactResponsible.class, this.stash, this.name)).core$().as(SlackContactResponsible.class);
            newElement.core$().set((Layer)newElement, "slackChannel", Collections.singletonList(slackChannel));
            return newElement;
        }

        public Configuration configuration() {
            Configuration newElement = (Configuration)((Configuration)AbstractGraph.this.graph.createRoot(Configuration.class, this.stash, this.name)).core$().as(Configuration.class);
            return newElement;
        }

        public Operation operation(String label) {
            Operation newElement = (Operation)((Operation)AbstractGraph.this.graph.createRoot(Operation.class, this.stash, this.name)).core$().as(Operation.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Deploy deploy(System project, String label) {
            Deploy newElement = (Deploy)((Deploy)AbstractGraph.this.graph.createRoot(Deploy.class, this.stash, this.name)).core$().as(Deploy.class);
            newElement.core$().set((Layer)newElement, "project", Collections.singletonList(project));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public ShutDown shutDown(String label) {
            ShutDown newElement = (ShutDown)((ShutDown)AbstractGraph.this.graph.createRoot(ShutDown.class, this.stash, this.name)).core$().as(ShutDown.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Move move(String label) {
            Move newElement = (Move)((Move)AbstractGraph.this.graph.createRoot(Move.class, this.stash, this.name)).core$().as(Move.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }

        public Monitor monitor(String label) {
            Monitor newElement = (Monitor)((Monitor)AbstractGraph.this.graph.createRoot(Monitor.class, this.stash, this.name)).core$().as(Monitor.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }
    }
}

