/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.countermeasures.notifications;

import io.intino.cesar.box.CesarBotSlackBot;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.countermeasures.notifications.Email;
import io.intino.cesar.graph.Responsible;
import java.util.Collections;
import java.util.List;

public class EventNotifier {
    private final CesarBotSlackBot bot;

    public EventNotifier(CesarBox box) {
        this.bot = box.cesarBot();
    }

    public void notify(List<Responsible> responsibles, String subject, String message) {
        for (Responsible responsible : responsibles) {
            if (responsible == null) continue;
            if (responsible.isEmailContact()) {
                Email.send(Collections.singletonList(responsible.asEmailContact().email()), subject, message);
            }
            if (!responsible.isSlackContact()) continue;
            this.notify(responsible.asSlackContact().slackChannel(), subject, message);
        }
    }

    public void notify(String slackUser, String subject, String message) {
        this.bot.sendToUser(slackUser, "*" + subject + "*: " + message);
    }
}

