/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.countermeasures.device;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.countermeasures.device.DeviceCounterMeasure;
import io.intino.cesar.countermeasures.notifications.EventNotifier;
import io.intino.cesar.graph.Device;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;

public class DeviceNotifier
extends DeviceCounterMeasure {
    private final EventNotifier eventNotifier;

    public DeviceNotifier(CesarBox box, Device.Sensors sensor) {
        super(box, sensor);
        this.eventNotifier = new EventNotifier(box);
    }

    @Override
    public void execute(Device device) {
        this.eventNotifier.notify(device.responsibles(), MessageProvider.message("device." + this.sensor.name().toLowerCase() + ".subject", this.parameters(device)), MessageProvider.message("device." + this.sensor.name().toLowerCase() + ".body", this.parameters(device)));
    }

    private String[] parameters(Device device) {
        switch (this.sensor) {
            case disconnected: {
                return new String[]{device.label(), device.status().toString()};
            }
            case highTemperature: {
                return new String[]{device.label(), String.valueOf(device.graph().configuration().deviceTemperatureThreshold())};
            }
            case lowBattery: {
                return new String[]{device.label(), String.valueOf(device.graph().configuration().deviceBatteryThreshold())};
            }
            case veryLowBattery: {
                return new String[]{device.label(), String.valueOf(device.graph().configuration().deviceLowBatteryThreshold())};
            }
            case unplugged: {
                return new String[]{device.label()};
            }
        }
        return new String[0];
    }

    static class MessageProvider {
        private static final String PATH_TO_BUNDLE = "notifications.properties";
        private static Properties props = new Properties();

        MessageProvider() {
        }

        public static String message(String key, String ... params) {
            Properties properties = MessageProvider.getProperties();
            return properties == null || !properties.containsKey(key) ? "" : MessageFormat.format((String)properties.get(key), params);
        }

        private static Properties getProperties() {
            try {
                if (props == null) {
                    props.load(MessageProvider.class.getResourceAsStream("/notifications.properties"));
                }
                return props;
            }
            catch (IOException ignored) {
                return null;
            }
        }
    }
}

