/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.countermeasures;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.countermeasures.CounterMeasure;
import io.intino.cesar.countermeasures.device.DeviceNotifier;
import io.intino.cesar.countermeasures.device.RecoverApplication;
import io.intino.cesar.countermeasures.device.TurnOffScreen;
import io.intino.cesar.countermeasures.device.TurnOnScreen;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Server;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CounterMeasureMap {

    public static class SystemFails {
        Map<Device.Sensors, List<CounterMeasure<System>>> counterMeasures = new HashMap<Device.Sensors, List<CounterMeasure<System>>>();
    }

    public static class ServerFails {
        Map<Device.Sensors, List<CounterMeasure<Server>>> counterMeasures = new HashMap<Device.Sensors, List<CounterMeasure<Server>>>();
    }

    public static class DeviceFails
    extends CounterMeasureMap {
        static Map<Device.Sensors, List<Class<? extends CounterMeasure<Device>>>> counterMeasures = new HashMap<Device.Sensors, List<Class<? extends CounterMeasure<Device>>>>();
        static Map<Device.Sensors, List<Class<? extends CounterMeasure<Device>>>> resetMeasures = new HashMap<Device.Sensors, List<Class<? extends CounterMeasure<Device>>>>();

        public static List<CounterMeasure<Device>> get(Device.Sensors sensor, CesarBox box) {
            try {
                ArrayList<CounterMeasure<Device>> list = new ArrayList<CounterMeasure<Device>>();
                for (Class<? extends CounterMeasure<Device>> aClass : counterMeasures.get((Object)sensor)) {
                    list.add((CounterMeasure)aClass.getConstructors()[0].newInstance(new Object[]{box, sensor}));
                }
                return list;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                return Collections.emptyList();
            }
        }

        public static List<CounterMeasure<Device>> reset(Device.Sensors sensor, CesarBox box) {
            try {
                ArrayList<CounterMeasure<Device>> list = new ArrayList<CounterMeasure<Device>>();
                for (Class<? extends CounterMeasure<Device>> aClass : resetMeasures.get((Object)sensor)) {
                    list.add((CounterMeasure)aClass.getConstructors()[0].newInstance(new Object[]{box, sensor}));
                }
                return list;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                return Collections.emptyList();
            }
        }

        static {
            counterMeasures.put(Device.Sensors.disconnected, Collections.singletonList(DeviceNotifier.class));
            counterMeasures.put(Device.Sensors.lowBattery, Collections.singletonList(DeviceNotifier.class));
            counterMeasures.put(Device.Sensors.veryLowBattery, Arrays.asList(TurnOffScreen.class, DeviceNotifier.class));
            counterMeasures.put(Device.Sensors.highTemperature, Arrays.asList(TurnOffScreen.class, DeviceNotifier.class));
            counterMeasures.put(Device.Sensors.misconfigured, Arrays.asList(RecoverApplication.class, DeviceNotifier.class));
            counterMeasures.put(Device.Sensors.unplugged, Collections.singletonList(DeviceNotifier.class));
            resetMeasures.put(Device.Sensors.disconnected, Collections.emptyList());
            resetMeasures.put(Device.Sensors.lowBattery, Collections.emptyList());
            resetMeasures.put(Device.Sensors.veryLowBattery, Collections.emptyList());
            resetMeasures.put(Device.Sensors.highTemperature, Collections.singletonList(TurnOnScreen.class));
            resetMeasures.put(Device.Sensors.unplugged, Collections.emptyList());
        }
    }
}

