/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.connectors.DeviceCommander;
import io.intino.cesar.box.schemas.CommandExecuted;
import io.intino.cesar.box.slack.helpers.GridGenerator;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.graph.Device;
import io.intino.screenclassifier.ScreenDetector;

class ScreenChecker {
    private final CesarBox box;
    private final Device device;

    ScreenChecker(CesarBox box, Device device) {
        this.box = box;
        this.device = device;
    }

    boolean check() {
        byte[] screen = this.screen();
        return screen == null || new ScreenDetector().decide(screen) == ScreenDetector.Correctness.Correct;
    }

    private byte[] screen() {
        DeviceCommander deviceCommander = new DeviceCommander(this.box.datalake(), this.device, this.box.consulTopic());
        String message = deviceCommander.captureScreen();
        if (!ScreenChecker.valid(message)) {
            return null;
        }
        CommandExecuted commandExecuted = Query.DeviceHelper.executedCommand(message);
        String prefix = "ERROR:";
        if (!commandExecuted.remarks().startsWith(prefix)) {
            return GridGenerator.decode(commandExecuted.remarks());
        }
        return null;
    }

    private static boolean valid(String result) {
        return !result.startsWith("Error");
    }
}

