/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.checkers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.checkers.ScreenChecker;
import io.intino.cesar.countermeasures.CounterMeasureMap;
import io.intino.cesar.graph.Configuration;
import io.intino.cesar.graph.Device;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class DeviceStatusChecker {
    private Device device;
    private final CesarBox box;
    private final Configuration configuration;

    public DeviceStatusChecker(Device device, CesarBox box) {
        this.box = box;
        this.device = device;
        this.configuration = box.graph().configuration();
    }

    public void check() {
        if (this.device.status() == null) {
            return;
        }
        this.checkUnplug();
        this.checkLowBattery();
        this.checkHighTemperature();
        this.checkVeryLowBattery();
        this.checkDisconnected();
        this.checkScreen();
        this.device.compromised(this.isCompromised());
        this.device.core$().save();
    }

    private void checkScreen() {
        if (!this.device.status().isScreenOn()) {
            return;
        }
        if (!new ScreenChecker(this.box, this.device).check()) {
            this.executeCounterMeasure(Device.Sensors.misconfigured);
        } else if (!DeviceStatusChecker.isUnPlugged(this.device)) {
            this.resetCounterMeasure(Device.Sensors.misconfigured);
            this.resetActiveStatus(this.device, Device.Active.misconfigured);
        }
    }

    private void checkUnplug() {
        if (DeviceStatusChecker.isUnPlugged(this.device) && !this.device.active().contains((Object)Device.Active.unplugged)) {
            this.device.active().add(Device.Active.unplugged);
            this.executeCounterMeasure(Device.Sensors.unplugged);
        } else if (!DeviceStatusChecker.isUnPlugged(this.device)) {
            this.resetCounterMeasure(Device.Sensors.unplugged);
            this.resetActiveStatus(this.device, Device.Active.unplugged);
        }
    }

    private void checkLowBattery() {
        if (DeviceStatusChecker.lowBattery(this.device) && !this.device.active().contains((Object)Device.Active.lowBattery)) {
            this.device.active().add(Device.Active.lowBattery);
            this.executeCounterMeasure(Device.Sensors.lowBattery);
        } else if (this.device.status().battery() >= (double)this.configuration.deviceBatteryThreshold()) {
            this.resetCounterMeasure(Device.Sensors.lowBattery);
            this.resetActiveStatus(this.device, Device.Active.lowBattery);
        }
    }

    private void checkHighTemperature() {
        if (DeviceStatusChecker.highTemperature(this.device) && !this.device.active().contains((Object)Device.Active.highTemperature)) {
            this.device.active().add(Device.Active.highTemperature);
            this.executeCounterMeasure(Device.Sensors.highTemperature);
        } else if (this.device.status().temperature() < (double)this.configuration.deviceTemperatureThreshold() && this.device.active().contains((Object)Device.Active.highTemperature)) {
            this.resetCounterMeasure(Device.Sensors.highTemperature);
            this.resetActiveStatus(this.device, Device.Active.highTemperature);
        }
    }

    private void checkVeryLowBattery() {
        if (DeviceStatusChecker.veryLowBattery(this.device) && !this.device.active().contains((Object)Device.Active.lowBattery)) {
            this.device.active().add(Device.Active.lowBattery);
            this.executeCounterMeasure(Device.Sensors.veryLowBattery);
        } else if (!DeviceStatusChecker.veryLowBattery(this.device)) {
            this.resetCounterMeasure(Device.Sensors.veryLowBattery);
            this.resetActiveStatus(this.device, Device.Active.lowBattery);
        }
    }

    private void checkDisconnected() {
        if (DeviceStatusChecker.isDisconnected(this.device) && !this.device.active().contains((Object)Device.Active.disconnected)) {
            this.device.active().add(Device.Active.disconnected);
            this.executeCounterMeasure(Device.Sensors.disconnected);
        } else if (!DeviceStatusChecker.isDisconnected(this.device)) {
            this.resetCounterMeasure(Device.Sensors.disconnected);
            this.resetActiveStatus(this.device, Device.Active.disconnected);
        }
    }

    private void executeCounterMeasure(Device.Sensors highTemperature) {
        CounterMeasureMap.DeviceFails.get(highTemperature, this.box).forEach(c -> c.execute(this.device));
    }

    private void resetCounterMeasure(Device.Sensors highTemperature) {
        CounterMeasureMap.DeviceFails.reset(highTemperature, this.box).forEach(c -> c.execute(this.device));
    }

    private void resetActiveStatus(Device device, Device.Active active) {
        device.active().remove((Object)active);
    }

    private boolean isCompromised() {
        return DeviceStatusChecker.isDisconnected(this.device) || DeviceStatusChecker.lowBattery(this.device) || DeviceStatusChecker.highTemperature(this.device) || DeviceStatusChecker.isUnPlugged(this.device) || !this.device.status().isScreenOn();
    }

    public static boolean isDisconnected(Device device) {
        return device.status() != null && device.status().created().until(Instant.now(), ChronoUnit.HOURS) > (long)device.graph().configuration().disconnectedTimeThreshold();
    }

    public static boolean veryLowBattery(Device device) {
        return device.status().battery() < (double)device.graph().configuration().deviceLowBatteryThreshold();
    }

    public static boolean lowBattery(Device device) {
        return device.status().battery() < (double)device.graph().configuration().deviceBatteryThreshold();
    }

    public static boolean highTemperature(Device device) {
        return device.status().temperature() >= (double)device.graph().configuration().deviceTemperatureThreshold();
    }

    public static boolean isUnPlugged(Device device) {
        return !device.status().isPlugged();
    }
}

