/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack.helpers;

import io.intino.cesar.box.schemas.Status;
import io.intino.cesar.checkers.DeviceStatusChecker;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceDigest;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerDigest;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.SystemDigest;
import io.intino.consul.schemas.ServerStatus;
import io.intino.consul.schemas.SystemStatus;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Logger;

public class SlackMessageFormatter {
    private static final String NO_INFO_YET = "> No info yet";
    private static Logger logger = Logger.getGlobal();

    public static String format(DeviceDigest status, String timeZone) {
        DecimalFormat df = new DecimalFormat("0.0#");
        return status == null ? "no status" : ":battery:`" + df.format(status.battery()) + "`   :electric_plug:`" + SlackMessageFormatter.state(status.isPlugged()) + "`   :thermometer:`" + df.format(status.temperature()) + "`   :hammer_and_pick:`" + df.format(status.cpuUsage()) + "`   :desktop_computer:`" + SlackMessageFormatter.state(status.isScreenOn()) + "`   :clock10:`" + SlackMessageFormatter.formatInstant(timeZone, status.created()) + "`";
    }

    public static String time(Instant instant, String timeZone) {
        return ":clock10:`" + SlackMessageFormatter.formatInstant(timeZone, instant) + "`";
    }

    private static String hdd(double entry) {
        return ":harddisk:`" + entry + "%`";
    }

    private static String memory(double entry) {
        return ":memory:`" + entry + "%`";
    }

    private static String memoryInAmount(double entry) {
        return ":memory:`" + entry + "mb`";
    }

    private static String connections(double in, double out) {
        return ":network: (`" + in + "`:small_red_triangle_down: `" + out + "`:small_red_triangle:)";
    }

    private static String cpu(double entry) {
        return ":hammer_and_pick: `" + entry + "%`";
    }

    private static String threads(int entry) {
        return ":threads: `" + entry + "`";
    }

    public static String format(Status status, String timeZone) {
        DecimalFormat df = new DecimalFormat("0.0#");
        return status == null ? "no status" : ":battery:`" + df.format(status.battery()) + "`   :electric_plug:`" + SlackMessageFormatter.state(status.isPlugged()) + "`   :thermometer:`" + df.format(status.temperature()) + "`   :hammer_and_pick:`" + df.format(status.cpuUsage()) + "`   :desktop_computer:`" + SlackMessageFormatter.state(status.isScreenOn()) + "`   :clock10:`" + SlackMessageFormatter.formatInstant(timeZone, status.created() == null ? Instant.now() : status.created()) + "`";
    }

    public static String format(Server server, ServerDigest status, String timeZone) {
        StringBuilder builder = new StringBuilder();
        if (status == null) {
            builder.append(NO_INFO_YET);
        } else if (server.isDisconnected()) {
            builder.append("> *Disconnected*");
        } else {
            builder.append("> ").append(SlackMessageFormatter.cpu(status.usedCPU())).append(" ").append(SlackMessageFormatter.memory(status.usedMemory())).append(" ").append(SlackMessageFormatter.hdd(status.usedDisk())).append(" ").append(SlackMessageFormatter.connections(status.inboundConnections(), status.outboundConnections())).append(" ").append(SlackMessageFormatter.time(status.created(), timeZone));
        }
        return builder.toString();
    }

    public static String format(ServerStatus status, String timeZone) {
        StringBuilder builder = new StringBuilder();
        if (status == null) {
            builder.append("no status");
        } else {
            builder.append("\n\t").append(SlackMessageFormatter.cpu(status.cpu())).append(" ").append(SlackMessageFormatter.memory(status.memory())).append(" ").append(SlackMessageFormatter.hdd(status.hdd())).append(" ").append(SlackMessageFormatter.connections(status.inboundConnections().intValue(), status.outboundConnections().intValue())).append(" ").append(SlackMessageFormatter.time(status.ts(), timeZone));
        }
        return builder.toString();
    }

    public static String format(SystemStatus status, String timeZone) {
        String result = "\n\t";
        if (status == null) {
            return result + NO_INFO_YET;
        }
        return result + SlackMessageFormatter.cpu(status.cpu()) + " " + SlackMessageFormatter.memoryInAmount(status.memory()) + " " + SlackMessageFormatter.threads(status.threads()) + " " + SlackMessageFormatter.time(status.ts(), timeZone);
    }

    public static String format(System system, String timeZone) {
        String result = "\n\t";
        System.Status systemStatus = system.status();
        if (systemStatus == null) {
            return result + NO_INFO_YET;
        }
        SystemDigest record = systemStatus.status();
        if (record == null) {
            return result + NO_INFO_YET;
        }
        return result + SlackMessageFormatter.cpu(record.cpu()) + " " + SlackMessageFormatter.memoryInAmount(record.memory()) + " " + SlackMessageFormatter.threads(record.threads()) + " " + SlackMessageFormatter.time(record.created(), timeZone);
    }

    public static String formatCompromised(Device device, String timeZone) {
        DeviceDigest status = device.status();
        DecimalFormat df = new DecimalFormat("0.0#");
        StringBuilder builder = new StringBuilder();
        if (device.status() == null) {
            return builder.append("`Disconnected. No data`").toString();
        }
        if (DeviceStatusChecker.isDisconnected(device)) {
            return builder.append("Disconnected since ").append("`").append(SlackMessageFormatter.formatInstant(timeZone, status.created())).append("`").toString();
        }
        if (DeviceStatusChecker.lowBattery(device)) {
            builder.append(":battery:`").append(df.format(status.battery())).append("`   ");
        }
        if (DeviceStatusChecker.isUnPlugged(device)) {
            builder.append(":electric_plug:`").append(SlackMessageFormatter.state(status.isPlugged())).append("`   ");
        }
        if (DeviceStatusChecker.highTemperature(device)) {
            builder.append(":thermometer:`").append(df.format(status.temperature())).append("`   ");
        }
        if (!status.isScreenOn()) {
            builder.append(":desktop_computer:`").append(SlackMessageFormatter.state(status.isScreenOn())).append("`   ");
        }
        builder.append(":clock10:`").append(SlackMessageFormatter.formatInstant(timeZone, status.created())).append("`");
        return builder.toString();
    }

    private static String formatInstant(String timeZone, Instant instant) {
        return DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss").withZone(ZoneId.of(timeZone)).format(instant);
    }

    private static String state(boolean state) {
        return state ? "ON" : "OFF";
    }
}

