/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack.helpers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.connectors.DeviceCommander;
import io.intino.cesar.box.connectors.ServerCommander;
import io.intino.cesar.box.connectors.SystemCommander;
import io.intino.cesar.box.schemas.CommandExecuted;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.konos.datalake.Ness;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Query {
    static CesarGraph cesar(CesarBox box) {
        return box.graph();
    }

    public static class SystemHelper {
        public static SystemCommander commander(Ness datalake, System system) {
            return new SystemCommander(datalake, system);
        }

        public static Stream<System> sortedSystems(CesarBox box) {
            return SystemHelper.systems(box).stream().sorted((s1, s2) -> String.CASE_INSENSITIVE_ORDER.compare(s1.alias(), s2.alias()));
        }

        public static String isRunning(System system) throws IOException {
            return system.isRunning() ? "started" : "stopped";
        }

        public static System findSystemByName(CesarBox box, String name) {
            for (System system : SystemHelper.systems(box)) {
                if (!system.alias().equals(name) && !system.name$().equals(name)) continue;
                return system;
            }
            return null;
        }

        public static List<System> systems(CesarBox box) {
            return Query.cesar(box).systemList();
        }

        public static System searchSystemByPosition(CesarBox box, String id) {
            List systems = SystemHelper.sortedSystems(box).collect(Collectors.toList());
            try {
                int position = Integer.parseInt(id);
                return position <= systems.size() ? (System)((Object)systems.get(position - 1)) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public static System searchSystemByName(CesarBox box, String alias) {
            for (System system : Query.cesar(box).systemList()) {
                if (!system.alias().equals(alias)) continue;
                return system;
            }
            return null;
        }
    }

    public static class DeviceHelper {
        public static DeviceCommander commander(CesarBox box, Device device) {
            return new DeviceCommander(box.datalake(), device, box.consulTopic());
        }

        public static Stream<Device> sortedDevices(CesarBox box) {
            return DeviceHelper.devices(box).stream().sorted((s1, s2) -> String.CASE_INSENSITIVE_ORDER.compare(s1.label(), s2.label()));
        }

        static List<Device> devices(CesarBox box) {
            CesarGraph application = Query.cesar(box);
            return application.infrastructure().unitList().stream().filter(u -> u instanceof Device).map(u -> (Device)u.core$().as(Device.class)).collect(Collectors.toList());
        }

        public static String label(Device device) {
            return device.status() == null || device.compromised() ? "*" + device.label() + "*" : device.label();
        }

        public static boolean valid(String result) {
            return !result.startsWith("Error");
        }

        public static boolean state(String alert) {
            return alert.equals("on");
        }

        public static CommandExecuted executedCommand(String message) {
            return MessageManager.fromInl(message, CommandExecuted.class).get(0);
        }

        public static Device searchDeviceByPosition(CesarBox box, String id) {
            try {
                List devices = DeviceHelper.sortedDevices(box).collect(Collectors.toList());
                int position = Integer.parseInt(id);
                return position <= devices.size() ? (Device)((Object)devices.get(position - 1)) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public static Device searchDeviceByLabel(CesarBox box, String label) {
            for (Device device : DeviceHelper.devices(box)) {
                if (!device.label().equals(label)) continue;
                return device;
            }
            return null;
        }

        public static Device findDeviceByName(CesarBox box, String name) {
            for (Device device : DeviceHelper.devices(box)) {
                if (!device.alias().equals(name) && !device.label().equals(name)) continue;
                return device;
            }
            return null;
        }
    }

    public static class ServerHelper {
        public static ServerCommander commander(Ness datalake, Server server) {
            return new ServerCommander(datalake, server);
        }

        public static Stream<Server> sortedServers(CesarBox box) {
            return ServerHelper.servers(box).stream().sorted((s1, s2) -> String.CASE_INSENSITIVE_ORDER.compare(s1.name$(), s2.name$()));
        }

        public static List<Server> servers(CesarBox box) {
            CesarGraph application = Query.cesar(box);
            return application.infrastructure().unitList().stream().filter(u -> u instanceof Server).map(u -> (Server)u.core$().as(Server.class)).collect(Collectors.toList());
        }

        public static Server searchServerByPosition(CesarBox box, String pos) {
            try {
                List servers = ServerHelper.sortedServers(box).collect(Collectors.toList());
                int position = Integer.parseInt(pos);
                return position <= servers.size() ? (Server)((Object)servers.get(position - 1)) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public static Server searchServerByName(CesarBox box, String name) {
            for (Server server : ServerHelper.servers(box)) {
                if (!server.name$().equals(name)) continue;
                return server;
            }
            return null;
        }
    }
}

