/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack.helpers;

import io.intino.cesar.graph.Device;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import sun.misc.BASE64Decoder;

public class GridGenerator {
    private static final int ROWS = 15;

    public static byte[] decode(String base64) {
        return GridGenerator.bytesOf(base64);
    }

    public static byte[] decodeWithGrid(String base64, Device device) {
        BufferedImage image = GridGenerator.bufferedImageFrom(base64);
        if (image == null) {
            return new byte[0];
        }
        device.screen().height(image.getHeight());
        device.screen().width(image.getWidth());
        return GridGenerator.merge(image, GridGenerator.createGridFor(device));
    }

    public static int pixelXOf(String position, Device device) {
        int size = device.screen().height() / 15;
        int level = Character.toUpperCase(position.charAt(0)) - 65;
        return level * size + size / 2;
    }

    public static int pixelYOf(String position, Device device) {
        int size = device.screen().height() / 15;
        int level = Integer.valueOf(position.substring(1));
        return level * size + size / 2;
    }

    private static byte[] merge(BufferedImage image, BufferedImage gridFor) {
        try {
            image.getGraphics().drawImage(gridFor, 0, 0, null);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "jpg", stream);
            stream.flush();
            return stream.toByteArray();
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, e.getMessage(), e);
            return new byte[0];
        }
    }

    private static BufferedImage createGridFor(Device device) {
        int size = device.screen().height() / 15;
        BufferedImage img = new BufferedImage(device.screen().width(), device.screen().height(), 2);
        Graphics2D g2d = img.createGraphics();
        GridGenerator.transparentRect(device, g2d);
        GridGenerator.drawLines(device, size, g2d);
        GridGenerator.drawStrings(device, size, g2d);
        return img;
    }

    private static void transparentRect(Device device, Graphics2D g2d) {
        g2d.setComposite(AlphaComposite.Clear);
        g2d.fillRect(0, 0, device.screen().width(), device.screen().height());
    }

    private static void drawLines(Device device, int size, Graphics2D g2d) {
        g2d.setComposite(AlphaComposite.Src);
        g2d.setColor(Color.gray);
        BasicStroke bs = new BasicStroke(2.0f);
        g2d.setStroke(bs);
        for (int i = 1; i < 15; ++i) {
            g2d.drawLine(0, i * size, device.screen().width(), i * size);
        }
        for (int rectWidth = size; rectWidth < device.screen().width(); rectWidth += size) {
            g2d.drawLine(rectWidth, 0, rectWidth, device.screen().height());
        }
    }

    private static void drawStrings(Device device, int size, Graphics2D g2d) {
        g2d.setFont(new Font("Verdana", 1, 14));
        g2d.setColor(Color.black);
        int number = 0;
        for (int i = 0; i < 15; ++i) {
            char letter = 'A';
            int rectWidth = 0;
            while (rectWidth < device.screen().width()) {
                g2d.drawString(String.valueOf(letter) + number, rectWidth + size / 2 - 7, i * size + size / 2 + 7);
                rectWidth += size;
                letter = (char)(letter + '\u0001');
            }
            ++number;
        }
    }

    private static BufferedImage bufferedImageFrom(String base64) {
        try {
            return ImageIO.read(new ByteArrayInputStream(GridGenerator.bytesOf(base64)));
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static byte[] bytesOf(String base64) {
        try {
            return new BASE64Decoder().decodeBuffer(base64);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, e.getMessage(), e);
            return new byte[0];
        }
    }
}

