/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.connectors.SystemCommander;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.graph.Responsible;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.consul.schemas.Operation;
import io.intino.consul.schemas.OperationResult;
import io.intino.consul.schemas.SystemLog;
import io.intino.consul.schemas.SystemStatus;
import io.intino.konos.slack.Bot;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SystemSlack {
    private static final String NO_SYSTEM = "No system has been connected";
    private static final String OK = ":ok_hand:";
    private static final String CANNOT_REQUEST = "System couldn't be requested";
    private CesarBox box;

    public SystemSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
    }

    public String status(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return NO_SYSTEM;
        }
        SystemStatus status = Query.SystemHelper.commander(this.box.datalake(), system).status();
        if (status != null) {
            return system.alias() + "> " + SlackMessageFormatter.format(status, properties.userTimeZone());
        }
        return CANNOT_REQUEST;
    }

    public String name(Bot.MessageProperties properties, String newName) {
        System system = this.findSystem(properties);
        if (system == null) {
            return NO_SYSTEM;
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("rename", properties.username(), system, newName));
        return OK;
    }

    public String log(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        SystemLog log = Query.SystemHelper.commander(this.box.datalake(), system).log();
        if (!log.value().isEmpty()) {
            this.box.cesarBot().sendFile(properties.channel(), system.alias() + ".txt", log.value().getBytes());
        }
        return "Requesting log...";
    }

    public String responsibles(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return NO_SYSTEM;
        }
        StringBuilder builder = new StringBuilder();
        for (Responsible responsible : system.responsibles()) {
            builder.append(responsible.label());
            if (responsible.isSlackContact()) {
                builder.append(": ").append(responsible.asSlackContact().slackChannel());
            }
            if (!responsible.isEmailContact()) continue;
            builder.append(" ").append(responsible.asEmailContact().email()).append("\n");
        }
        String result = builder.toString();
        return result.isEmpty() ? "No responsibles are registered." : result;
    }

    public String parameter(Bot.MessageProperties properties, String name, String value) {
        System system = this.findSystem(properties);
        if (system == null) {
            return NO_SYSTEM;
        }
        System.Deployment deployment = system.deploymentList().get(system.deploymentList().size() - 1);
        return String.join((CharSequence)"\n", deployment.parameterList().stream().map(p -> p.name$() + " = " + p.value()).collect(Collectors.toList()));
    }

    public String start(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return NO_SYSTEM;
        }
        Boolean success = Query.SystemHelper.commander(this.box.datalake(), system).start();
        return success != null ? system.alias() + "> started on " + ((Server)system.consul().core$().ownerAs(Server.class)).name$() : CANNOT_REQUEST;
    }

    public String debug(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return NO_SYSTEM;
        }
        Boolean success = Query.SystemHelper.commander(this.box.datalake(), system).debug();
        return success != null ? system.alias() + "> started on debug. Open console and start tunnel:\n" + this.connectionChain(system) : CANNOT_REQUEST;
    }

    public String stop(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return NO_SYSTEM;
        }
        Boolean success = Query.SystemHelper.commander(this.box.datalake(), system).stop();
        return success != null ? system.alias() + "> stopped on " + ((Server)system.consul().core$().ownerAs(Server.class)).name$() : CANNOT_REQUEST;
    }

    public String restart(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return NO_SYSTEM;
        }
        Boolean success = Query.SystemHelper.commander(this.box.datalake(), system).restart();
        return success != null ? system.alias() + "> restarted on " + ((Server)system.consul().core$().ownerAs(Server.class)).name$() : CANNOT_REQUEST;
    }

    public String parameters(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        if (system == null) {
            return NO_SYSTEM;
        }
        System.Deployment deployment = system.deploymentList().get(system.deploymentList().size() - 1);
        return String.join((CharSequence)"\n", deployment.parameterList().stream().map(p -> p.name$() + " = " + p.value()).collect(Collectors.toList()));
    }

    public String setResponsibles(Bot.MessageProperties properties, String[] users) {
        List<String> newResponsibleNames = Arrays.asList(users);
        System system = this.findSystem(properties);
        if (system == null) {
            return NO_SYSTEM;
        }
        List responsibles = this.box.graph().responsibleList(r -> newResponsibleNames.contains(r.username())).collect(Collectors.toList());
        if (responsibles.size() != newResponsibleNames.size()) {
            return "Some responsible hasn't been found";
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("setResponsibles", properties.username(), system, users));
        return OK;
    }

    public String datalake(Bot.MessageProperties properties) {
        properties.context().command("systemDatalake");
        return "Connected to " + properties.context().getObjects()[0] + " datalake";
    }

    private String connectionChain(System system) {
        Server server = (Server)system.consul().core$().ownerAs(Server.class);
        String[] url = server.url().split(":");
        return "`ssh -N -p " + url[1] + " intino@" + url[0] + " -L " + system.debugPort() + ":127.0.0.1:" + system.debugPort() + "`";
    }

    private System findSystem(Bot.MessageProperties properties) {
        Bot.Context context = properties.context();
        if (context == null) {
            return null;
        }
        System system = Query.SystemHelper.searchSystemByName(this.box, context.getObjects()[0]);
        return system == null ? Query.SystemHelper.searchSystemByPosition(this.box, context.getObjects()[0]) : system;
    }

    public String operations(Bot.MessageProperties properties) {
        System system = this.findSystem(properties);
        SystemCommander commander = new SystemCommander(this.box.datalake(), system);
        List<Operation> result = commander.operations();
        if (result != null) {
            StringBuilder builder = new StringBuilder(system.alias() + ">\n");
            for (Operation operation : result) {
                builder.append(operation.operation()).append("(").append(this.parameters(operation)).append(")\n");
            }
            return builder.toString();
        }
        return CANNOT_REQUEST;
    }

    private String parameters(Operation operation) {
        return String.join((CharSequence)", ", operation.parameters()).replace("java.util.", "").replace("java.lang.", "");
    }

    public String invoke(Bot.MessageProperties properties, String operation, String[] args) {
        System system = this.findSystem(properties);
        SystemCommander commander = new SystemCommander(this.box.datalake(), system);
        List<String> parameters = Arrays.asList(args);
        OperationResult result = commander.operation(system.alias(), new Operation().operation(operation).parameters(parameters.subList(1, parameters.size())));
        if (result != null) {
            return system.alias() + "> " + result.remarks();
        }
        return CANNOT_REQUEST;
    }
}

