/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.graph.Responsible;
import io.intino.cesar.graph.Server;
import io.intino.consul.schemas.ServerStatus;
import io.intino.konos.jms.MessageFactory;
import io.intino.konos.slack.Bot;

public class ServerSlack {
    private static final String OK = ":ok_hand:";
    private static final String NO_SERVER = "No server has been connected";
    private CesarBox box;

    public ServerSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
    }

    public String status(Bot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return NO_SERVER;
        }
        ServerStatus status = Query.ServerHelper.commander(this.box.datalake(), server).status();
        if (status != null) {
            this.box.datalake().newProducer("feed.consul.server.status").produce(MessageFactory.createMessageFor((Object)MessageManager.toInl(status)));
            return server.alias() + "> " + SlackMessageFormatter.format(status, properties.userTimeZone());
        }
        return "Server doesn't response";
    }

    public String responsibles(Bot.MessageProperties properties) {
        Server server = this.findServer(properties);
        if (server == null) {
            return NO_SERVER;
        }
        StringBuilder builder = new StringBuilder();
        for (Responsible responsible : server.responsibles()) {
            builder.append(responsible.label());
            if (responsible.isSlackContact()) {
                builder.append(": ").append(responsible.asSlackContact().slackChannel());
            }
            if (!responsible.isEmailContact()) continue;
            builder.append(" ").append(responsible.asEmailContact().email()).append("\n");
        }
        String result = builder.toString();
        return result.isEmpty() ? "No responsibles are registered." : result;
    }

    public String name(Bot.MessageProperties properties, String newName) {
        Server server = this.findServer(properties);
        if (server == null) {
            return NO_SERVER;
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("rename", properties.username(), server, newName));
        return OK;
    }

    public String remoteConnection(Bot.MessageProperties properties, String url, Integer port, String sshUser) {
        Server server = this.findServer(properties);
        if (server == null) {
            return NO_SERVER;
        }
        if (!url.isEmpty()) {
            server.create().remoteConnection(sshUser, url, port);
            server.core$().save();
            return OK;
        }
        if (server.remoteConnection() != null) {
            return server.remoteConnection().url() + ":" + server.remoteConnection().port();
        }
        return "Connection not found";
    }

    public String shutdown(Bot.MessageProperties properties) {
        return "";
    }

    public String reboot(Bot.MessageProperties properties) {
        return "";
    }

    public String log(Bot.MessageProperties properties) {
        return OK;
    }

    public String updateConsul(Bot.MessageProperties properties) {
        return "";
    }

    public String setResponsibles(Bot.MessageProperties properties, String[] users) {
        return "";
    }

    private Server findServer(Bot.MessageProperties properties) {
        Bot.Context context = properties.context();
        if (context == null) {
            return null;
        }
        Server server = Query.ServerHelper.searchServerByName(this.box, context.getObjects()[0]);
        return server == null ? Query.ServerHelper.searchServerByPosition(this.box, context.getObjects()[0]) : server;
    }
}

