/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.graph.System;
import io.intino.konos.slack.Bot;
import java.util.Arrays;

public class ManageSlack {
    private static final String DEVICE = "Device";
    private static final String SERVER = "Server";
    private static final String SYSTEM = "System";
    private static final String RESPONSIBLE = "Responsible";
    private static final String OK = ":ok_hand:";
    private CesarBox box;

    public ManageSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
    }

    public String addResponsible(Bot.MessageProperties properties, String user, String email, String[] fullName) {
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("add", properties.username(), RESPONSIBLE, user, String.join((CharSequence)" ", Arrays.copyOfRange(fullName, 2, fullName.length)), null, ManageSlack.cleanURL(email)));
        return OK;
    }

    public String removeResponsible(Bot.MessageProperties properties, String user) {
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("remove", properties.username(), RESPONSIBLE, user, new String[0]));
        return OK;
    }

    public String addDevices(Bot.MessageProperties properties, String[] devices) {
        StringBuilder builder = new StringBuilder();
        for (String tuple : devices) {
            String[] split = tuple.split(";");
            String result = this.addDevice(properties, split[0], split[1]);
            if (result.isEmpty()) continue;
            builder.append(split[1]).append("> ").append(result).append("\n");
        }
        String message = builder.toString();
        return message.isEmpty() ? OK : message;
    }

    public String addDevice(Bot.MessageProperties properties, String deviceId, String name) {
        String result = this.canAddDevice(deviceId, name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("add", properties.username(), DEVICE, deviceId, name));
        return OK;
    }

    public String removeDevice(Bot.MessageProperties properties, String deviceId) {
        String result = this.canRemoveDevice(deviceId);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("remove", properties.username(), DEVICE, deviceId, new String[0]));
        return OK;
    }

    public String addServer(Bot.MessageProperties properties, String alias, String url, String ip) {
        String result = this.canAddServer(alias, url = ManageSlack.cleanURL(url));
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("add", properties.username(), SERVER, alias, ip, url));
        return OK;
    }

    public String removeServer(Bot.MessageProperties properties, String name) {
        String result = this.canRemoveServer(name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("remove", properties.username(), SERVER, name, new String[0]));
        return OK;
    }

    public String removeSystem(Bot.MessageProperties properties, String name) {
        String result = this.canRemoveSystem(name);
        if (!result.isEmpty()) {
            return result;
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("remove", properties.username(), SYSTEM, name, new String[0]));
        return OK;
    }

    private static String cleanURL(String url) {
        return url.contains("|") ? url.split("\\|")[1].replaceAll(">|<", "") : url.replace("<", "").replace(">", "");
    }

    private String canAddDevice(String deviceId, String name) {
        if (Query.DeviceHelper.findDeviceByName(this.box, deviceId) != null || Query.DeviceHelper.findDeviceByName(this.box, name) != null) {
            return "Device id or name already exists";
        }
        return "";
    }

    private String canRemoveDevice(String deviceId) {
        return Query.DeviceHelper.findDeviceByName(this.box, deviceId) == null ? "device id not found" : "";
    }

    private String canRemoveSystem(String name) {
        System toRemove = Query.SystemHelper.findSystemByName(this.box, name);
        return toRemove == null ? "System not found" : "";
    }

    private String canAddServer(String alias, String url) {
        if (Query.ServerHelper.searchServerByName(this.box, alias) != null || Query.ServerHelper.searchServerByName(this.box, url) != null) {
            return "Server url or name already exists";
        }
        return "";
    }

    private String canRemoveServer(String name) {
        return Query.ServerHelper.searchServerByName(this.box, name) == null ? "No server has been connected" : "";
    }
}

