/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.schemas.CommandExecuted;
import io.intino.cesar.box.schemas.Status;
import io.intino.cesar.box.slack.helpers.GridGenerator;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Responsible;
import io.intino.konos.jms.MessageFactory;
import io.intino.konos.slack.Bot;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DeviceSlack {
    private static final String NO_DEVICE = "No device has been connected";
    private static final String OK = ":ok_hand:";
    private CesarBox box;

    public DeviceSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
    }

    public String status(Bot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        String response = Query.DeviceHelper.commander(this.box, device).status();
        if (Query.DeviceHelper.valid(response)) {
            List<Status> status = MessageManager.fromInl(response, Status.class);
            this.box.datalake().newProducer("feed.consul.device.status").produce(MessageFactory.createMessageFor((Object)MessageManager.toInl(status.get(0))));
            return device.label() + "> " + SlackMessageFormatter.format(status.get(0), properties.userTimeZone());
        }
        return device.label() + "> " + response;
    }

    public String responsibles(Bot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        StringBuilder builder = new StringBuilder();
        for (Responsible responsible : device.responsibles()) {
            builder.append(responsible.label());
            if (responsible.isSlackContact()) {
                builder.append(": ").append(responsible.asSlackContact().slackChannel());
            }
            if (!responsible.isEmailContact()) continue;
            builder.append(" ").append(responsible.asEmailContact().email()).append("\n");
        }
        String result = builder.toString();
        return result.isEmpty() ? "No responsibles are registered." : result;
    }

    public String setResponsibles(Bot.MessageProperties properties, String[] users) {
        List<String> newResponsibleNames = Arrays.asList(users);
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        List responsibles = this.box.graph().responsibleList(r -> newResponsibleNames.contains(r.username())).collect(Collectors.toList());
        if (responsibles.size() != newResponsibleNames.size()) {
            return "Some responsible hasn't been found";
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("setresponsibles", properties.username(), device, users));
        return OK;
    }

    public String setNotifications(Bot.MessageProperties properties, String unplug, String temperature, String battery, String lowBattery, String disconnected) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("setnotifications", properties.username(), device, "" + Query.DeviceHelper.state(unplug), "" + Query.DeviceHelper.state(temperature), "" + Query.DeviceHelper.state(battery), "" + Query.DeviceHelper.state(lowBattery), "" + Query.DeviceHelper.state(disconnected)));
        return "Notifications are now: \n\tunplug:" + unplug + "\n\ttemperature:" + temperature + "\n\tbattery:" + battery + "\n\tlowBattery:" + lowBattery + "\n\tdisconnected:" + disconnected + "\n";
    }

    public String captureScreen(Bot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        String capturedScreen = Query.DeviceHelper.commander(this.box, device).captureScreen();
        if (Query.DeviceHelper.valid(capturedScreen)) {
            CommandExecuted commandExecuted = Query.DeviceHelper.executedCommand(capturedScreen);
            String prefix = "ERROR:";
            if (!commandExecuted.remarks().startsWith(prefix)) {
                this.box.cesarBot().sendFile(properties.channel(), device.label() + "> Capture.jpg", GridGenerator.decode(commandExecuted.remarks()));
            } else {
                return "Device cannot capture screen:" + commandExecuted.remarks().substring(prefix.length());
            }
        }
        return Query.DeviceHelper.valid(capturedScreen) ? "" : device.label() + "> " + capturedScreen;
    }

    public String captureGrid(Bot.MessageProperties properties) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        String capturedScreen = Query.DeviceHelper.commander(this.box, device).captureScreen();
        if (Query.DeviceHelper.valid(capturedScreen)) {
            CommandExecuted commandExecuted = Query.DeviceHelper.executedCommand(capturedScreen);
            this.box.cesarBot().sendFile(properties.channel(), device.label() + "> Capture.jpg", GridGenerator.decodeWithGrid(commandExecuted.remarks(), device));
            return "";
        }
        return device.label() + "> " + capturedScreen;
    }

    public String screen(Bot.MessageProperties properties, String state) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        String screenon = Query.DeviceHelper.state(state) ? Query.DeviceHelper.commander(this.box, device).screenOn() : Query.DeviceHelper.commander(this.box, device).screenOff();
        return device.label() + "> " + (Query.DeviceHelper.valid(screenon) ? OK : screenon);
    }

    public String tap(Bot.MessageProperties properties, String square) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        return this.tapPixel(properties, GridGenerator.pixelXOf(square, device), GridGenerator.pixelYOf(square, device));
    }

    public String tapPixel(Bot.MessageProperties properties, int x, int y) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        String result = Query.DeviceHelper.commander(this.box, device).tap(x, y);
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? OK : result);
    }

    public String kill(Bot.MessageProperties properties, String packageName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        String result = Query.DeviceHelper.commander(this.box, device).killTask(packageName);
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? OK : result);
    }

    public String launch(Bot.MessageProperties properties, String packageName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        String result = Query.DeviceHelper.commander(this.box, device).launchTask(packageName);
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? OK : result);
    }

    public String uninstall(Bot.MessageProperties properties, String packageName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        String result = Query.DeviceHelper.commander(this.box, device).deleteAPK(packageName);
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? OK : result);
    }

    public String install(Bot.MessageProperties properties, String url) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        String result = Query.DeviceHelper.commander(this.box, device).installAPK(url);
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? OK : result);
    }

    public String name(Bot.MessageProperties properties, String newName) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("rename", properties.username(), device, newName));
        return OK;
    }

    public String update(Bot.MessageProperties properties, String url) {
        Device device = this.findDevice(properties);
        if (device == null) {
            return NO_DEVICE;
        }
        String result = Query.DeviceHelper.commander(this.box, device).updateAPK(url);
        this.box.slackLastActionUser(properties.username());
        return device.label() + "> " + (Query.DeviceHelper.valid(result) ? OK : result);
    }

    private Device findDevice(Bot.MessageProperties properties) {
        Bot.Context context = properties.context();
        if (context == null) {
            return null;
        }
        Device device = Query.DeviceHelper.searchDeviceByLabel(this.box, context.getObjects()[0]);
        return device == null ? Query.DeviceHelper.searchDeviceByPosition(this.box, context.getObjects()[0]) : device;
    }
}

