/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.slack;

import com.ullink.slack.simpleslackapi.SlackSession;
import io.intino.cesar.UserManager;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.ChangeCommitter;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.slack.helpers.Query;
import io.intino.cesar.box.slack.helpers.SlackMessageFormatter;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Responsible;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.Unit;
import io.intino.konos.slack.Bot;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class CesarBotSlack {
    private static final String NO_DEVICE = "No device has been connected";
    private static final String OK = ":ok_hand:";
    private static Logger logger = Logger.getGlobal();
    private CesarBox box;

    public CesarBotSlack(CesarBox box) {
        this.box = box;
    }

    public void init(SlackSession session) {
        UserManager.addUsersFromSlack(this.box, session.getUsers());
    }

    public String devices(Bot.MessageProperties properties) {
        List devices = Query.DeviceHelper.sortedDevices(this.box).collect(Collectors.toList());
        if (devices.isEmpty()) {
            return "There aren't devices registered";
        }
        StringBuilder result = new StringBuilder("Devices:\n");
        int pos = 1;
        for (Device d : devices) {
            result.append(pos++).append(") ").append(Query.DeviceHelper.label(d)).append("\t").append(SlackMessageFormatter.format(d.status(), properties.userTimeZone())).append("\n");
        }
        return result.toString();
    }

    public String devicesId(Bot.MessageProperties properties) {
        StringBuilder result = new StringBuilder();
        Query.DeviceHelper.sortedDevices(this.box).forEach(info -> result.append(Query.DeviceHelper.label(info)).append("\t").append(info.alias()).append("\n"));
        return result.toString().isEmpty() ? "There aren't devices registered yet" : result.toString();
    }

    public String systems(Bot.MessageProperties properties) {
        List systems = Query.SystemHelper.sortedSystems(this.box).collect(Collectors.toList());
        if (systems.isEmpty()) {
            return "There aren't systems registered";
        }
        StringBuilder result = new StringBuilder("Systems:\n");
        int pos = 1;
        for (System system : systems) {
            try {
                result.append(pos++).append(") ").append(system.alias()).append("> ").append(Query.SystemHelper.isRunning(system)).append(system.isRunning() ? SlackMessageFormatter.format(system, properties.userTimeZone()) : "").append("\n");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return result.toString();
    }

    public String servers(Bot.MessageProperties properties) {
        List servers = Query.ServerHelper.sortedServers(this.box).collect(Collectors.toList());
        if (servers.isEmpty()) {
            return "There aren't servers registered";
        }
        StringBuilder builder = new StringBuilder("Servers:\n");
        int pos = 1;
        for (Unit unit : servers) {
            Server server = (Server)unit.core$().as(Server.class);
            builder.append(pos++).append(") ").append(server.name$());
            builder.append(SlackMessageFormatter.format(server, server.status(), properties.userTimeZone())).append("\n");
        }
        return builder.toString();
    }

    public String responsibles(Bot.MessageProperties properties) {
        StringBuilder builder = new StringBuilder();
        for (Responsible responsible : this.box.graph().responsibleList()) {
            builder.append(responsible.username());
            builder.append(" (").append(responsible.label()).append("): ");
            if (!responsible.isEmailContact()) continue;
            builder.append(" ").append(responsible.asEmailContact().email()).append("\n");
        }
        String message = builder.toString();
        return message.trim().isEmpty() ? "There aren't responsibles registered" : message;
    }

    public String developToken(Bot.MessageProperties properties) {
        return properties.username();
    }

    public String notifications(Bot.MessageProperties properties, String state) {
        if (state.isEmpty()) {
            return "Notifications are " + (this.box.graph().configuration().notifications() ? "on" : "off");
        }
        if (!state.equals("on") && !state.equals("off")) {
            return "State does not match (on /off)";
        }
        ChangeCommitter.commit(this.box, InfrastructureOperation.message("Notifications", properties.username(), "Configuration", null, state.equals("on") + ""));
        return OK;
    }

    public String issues(Bot.MessageProperties properties) {
        StringBuilder result = new StringBuilder();
        List devices = Query.DeviceHelper.sortedDevices(this.box).collect(Collectors.toList());
        int pos = 1;
        for (Device d : devices) {
            int current = pos++;
            if (d.status() != null && !d.compromised()) continue;
            result.append(current).append(") ").append(Query.DeviceHelper.label(d)).append("\t").append(SlackMessageFormatter.formatCompromised(d, properties.userTimeZone())).append("\n");
        }
        return result.toString().isEmpty() ? "There aren't issues" : result.toString();
    }

    public String manage(Bot.MessageProperties properties) {
        properties.context().command("manage");
        return "Now you are in management area";
    }

    public String device(Bot.MessageProperties properties, String alias) {
        Device selected = Query.DeviceHelper.searchDeviceByPosition(this.box, alias);
        if (selected == null) {
            selected = Query.DeviceHelper.searchDeviceByLabel(this.box, alias);
        }
        if (selected == null) {
            return NO_DEVICE;
        }
        properties.context().command("device");
        properties.context().objects(new String[]{alias});
        return "Connected to " + selected.label();
    }

    public String server(Bot.MessageProperties properties, String name) {
        Server selected = Query.ServerHelper.searchServerByPosition(this.box, name);
        if (selected == null) {
            selected = Query.ServerHelper.searchServerByName(this.box, name);
        }
        if (selected == null) {
            return "Server not found";
        }
        properties.context().command("server");
        properties.context().objects(new String[]{name});
        return "Connected to " + selected.label();
    }

    public String system(Bot.MessageProperties properties, String systemID) {
        System selected = Query.SystemHelper.searchSystemByPosition(this.box, systemID);
        if (selected == null) {
            selected = Query.SystemHelper.searchSystemByName(this.box, systemID);
        }
        if (selected == null) {
            return "System not found";
        }
        properties.context().command("system");
        properties.context().objects(new String[]{selected.alias()});
        return "Connected to " + selected.alias();
    }
}

