/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.messagehandlers.infrastructure;

import io.intino.cesar.Utils;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.MessageManager;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureHandler;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.schemas.Artifactory;
import io.intino.cesar.box.schemas.Parameter;
import io.intino.cesar.box.schemas.SystemSchema;
import io.intino.cesar.graph.Artifact;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import io.intino.cesar.graph.System;
import java.util.stream.Collectors;

public class System {
    private static io.intino.cesar.graph.System findSystemByAlias(CesarGraph cesar, String name) {
        for (io.intino.cesar.graph.System system : cesar.systemList()) {
            if (!system.alias().equals(name) && !system.alias().equals(name)) continue;
            return system;
        }
        return null;
    }

    static class NewDeployment
    extends InfrastructureHandler {
        private final SystemSchema schema = (SystemSchema)MessageManager.gson().fromJson(this.parameters()[0], SystemSchema.class);

        public NewDeployment(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.System system = System.findSystemByAlias(this.cesar, this.objectID());
            if (system == null) {
                return;
            }
            system.artifact().classpathPrefix(this.schema.packaging().classpathPrefix());
            System.Deployment deployment = system.create().deployment();
            deployment.success(true);
            if (this.schema.packaging() != null) {
                for (Parameter newParameter : this.schema.packaging().parameterList()) {
                    deployment.create(newParameter.name()).parameter(newParameter.name(), newParameter.value());
                }
            }
            system.save$();
        }
    }

    static class Rename
    extends InfrastructureHandler {
        public Rename(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.System system = System.findSystemByAlias(this.cesar, this.objectID());
            system.alias(this.parameters()[0]);
            system.save$();
        }
    }

    static class Remove
    extends InfrastructureHandler {
        public Remove(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.System system = System.findSystemByAlias(this.cesar, this.parameters()[0]);
            system.delete$();
        }
    }

    static class Add
    extends InfrastructureHandler {
        private final SystemSchema schema = (SystemSchema)MessageManager.gson().fromJson(this.parameters()[0], SystemSchema.class);

        public Add(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.System newSystem = this.cesar.create("Systems", Utils.normalizedID(this.schema.id())).system(this.schema.id(), this.schema.publicURL());
            String[] split = this.schema.packaging().artifact().split(":");
            Artifact artifact = newSystem.create().artifact(split[0], split[1], split[2]);
            newSystem.create().status();
            newSystem.consul(this.findConsulByServer());
            for (Artifactory artifactory : this.schema.artifactoryList()) {
                artifact.create().artifactory(artifactory.url(), artifactory.id());
            }
            newSystem.save$();
        }

        private ServerConsul findConsulByServer() {
            Server server = (Server)((Object)this.box.graph().infrastructure().unitList(u -> u instanceof Server && u.name$().equals(this.schema.runtime().serverName())).stream().map(u -> (Server)((Object)u)).collect(Collectors.toList()).get(0));
            return server.serverConsul();
        }
    }
}

