/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.messagehandlers.infrastructure;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.messagehandlers.infrastructure.Device;
import io.intino.cesar.box.messagehandlers.infrastructure.Identifiable;
import io.intino.cesar.box.messagehandlers.infrastructure.Infrastructure;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureHandler;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.messagehandlers.infrastructure.Server;
import io.intino.cesar.box.messagehandlers.infrastructure.System;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class InfrastructureHandlerFactory {
    private static Map<String, Class<? extends InfrastructureHandler>> handlerMap = new HashMap<String, Class<? extends InfrastructureHandler>>();

    public static InfrastructureHandler get(CesarBox box, InfrastructureOperation operation) {
        try {
            Class<? extends InfrastructureHandler> handlerClass = handlerMap.get((operation.operation().toLowerCase() + ";" + operation.objectType().toLowerCase()).toLowerCase());
            if (handlerClass == null) {
                return null;
            }
            Constructor<?> constructor = handlerClass.getConstructors()[0];
            return (InfrastructureHandler)constructor.newInstance(new Object[]{box, operation});
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Logger.getGlobal().severe("Error handling event. " + operation.toString());
            return null;
        }
    }

    static {
        handlerMap.put("add;device", Device.Add.class);
        handlerMap.put("add;system", System.Add.class);
        handlerMap.put("add;server", Server.Add.class);
        handlerMap.put("remove;device", Device.Remove.class);
        handlerMap.put("remove;system", System.Remove.class);
        handlerMap.put("remove;server", Server.Remove.class);
        handlerMap.put("rename;device", Device.Rename.class);
        handlerMap.put("rename;system", System.Rename.class);
        handlerMap.put("rename;server", Server.Rename.class);
        handlerMap.put("upgrade;device", Server.Rename.class);
        handlerMap.put("setnotifications;device", Device.SetNotifications.class);
        handlerMap.put("newdeployment;system", System.NewDeployment.class);
        handlerMap.put("setresponsibles;system", Identifiable.SetResponsibles.class);
        handlerMap.put("setresponsibles;server", Identifiable.SetResponsibles.class);
        handlerMap.put("setresponsibles;device", Identifiable.SetResponsibles.class);
        handlerMap.put("add;responsible", Infrastructure.AddResponsible.class);
        handlerMap.put("notifications;configuration", Infrastructure.NotificationsConfiguration.class);
        handlerMap.put("remove;responsible", Infrastructure.RemoveResponsible.class);
    }
}

