/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.messagehandlers.infrastructure;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureHandler;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.graph.CesarGraph;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Infrastructure;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Device {
    private static io.intino.cesar.graph.Device findDeviceByName(CesarGraph cesar, String name) {
        List devices = cesar.infrastructure().unitList().stream().filter(u -> u instanceof io.intino.cesar.graph.Device).map(u -> (io.intino.cesar.graph.Device)u.core$().as(io.intino.cesar.graph.Device.class)).collect(Collectors.toList());
        for (io.intino.cesar.graph.Device device : devices) {
            if (!device.alias().equals(name) && !device.alias().equals(name)) continue;
            return device;
        }
        return null;
    }

    static class SetNotifications
    extends InfrastructureHandler {
        public SetNotifications(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.Device device = Device.findDeviceByName(this.cesar, this.objectID());
            ArrayList<Device.Sensors> list = new ArrayList<Device.Sensors>();
            if ("true".equals(this.parameters()[0])) {
                list.add(Device.Sensors.unplugged);
            }
            if ("true".equals(this.parameters()[1])) {
                list.add(Device.Sensors.highTemperature);
            }
            if ("true".equals(this.parameters()[2])) {
                list.add(Device.Sensors.lowBattery);
            }
            if ("true".equals(this.parameters()[3])) {
                list.add(Device.Sensors.veryLowBattery);
            }
            if ("true".equals(this.parameters()[4])) {
                list.add(Device.Sensors.disconnected);
            }
            device.sensors().clear();
            device.sensors().addAll(list);
            device.save$();
        }
    }

    public static class Upgrade
    extends InfrastructureHandler {
        public Upgrade(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.Device device = Device.findDeviceByName(this.cesar, this.objectID());
            device.consul().version(this.parameters()[0]);
            device.save$();
        }
    }

    static class Rename
    extends InfrastructureHandler {
        public Rename(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            io.intino.cesar.graph.Device device = Device.findDeviceByName(this.cesar, this.objectID());
            device.label(this.parameters()[0]);
            device.save$();
        }
    }

    static class Remove
    extends InfrastructureHandler {
        public Remove(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Infrastructure infrastructure = this.cesar.infrastructure();
            io.intino.cesar.graph.Device deviceByName = Device.findDeviceByName(this.cesar, this.objectID());
            deviceByName.delete$();
            infrastructure.save$();
        }
    }

    public static class Add
    extends InfrastructureHandler {
        public Add(CesarBox box, InfrastructureOperation operation) {
            super(box, operation);
        }

        @Override
        public void execute() {
            Infrastructure infrastructure = this.cesar.infrastructure();
            io.intino.cesar.graph.Device device = infrastructure.create(this.objectID()).device(this.objectID(), this.parameters()[0]);
            device.create().consul("1.0.0");
            device.create().screen("");
            device.create().temperature(0.0, 0.0, "");
            try {
                infrastructure.save$();
            }
            catch (Exception e) {
                Logger.getGlobal().severe(e.getMessage());
            }
        }
    }
}

