/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.checkers.SystemStatusChecker;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.SystemDigest;
import io.intino.consul.schemas.SystemStatus;
import io.intino.ness.inl.Message;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.rules.TimeScale;
import java.time.Instant;

public class SystemStatusMessageHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        SystemStatus status = (SystemStatus)this.message.as(SystemStatus.class);
        System system = this.findSystem(status.id());
        if (system == null) {
            return;
        }
        this.mount(system, status);
        new SystemStatusChecker(system, this.box).check();
    }

    private void mount(System system, SystemStatus status) {
        system.status().status(new SystemDigest(this.createDigest(system, TimeScale.FifteenMinutes, status)));
        this.createDigest(system, TimeScale.Hour, status);
        this.createDigest(system, TimeScale.SixHours, status);
        this.createDigest(system, TimeScale.Day, status);
        this.createDigest(system, TimeScale.Month, status);
        this.createDigest(system, TimeScale.Year, status);
    }

    private Digest createDigest(System system, TimeScale scale, SystemStatus status) {
        Digest digest = this.newDigest(scale, system, status.ts());
        digest.set("cpu", (float)status.cpu());
        digest.set("memory", (float)status.memory());
        digest.set("threads", status.threads().intValue());
        digest.save();
        return digest;
    }

    private Digest newDigest(TimeScale scale, System system, Instant instant) {
        return this.box.graph().deviceCube().getOrCreateBucket(this.box.graph().default$(), scale, instant).digest(new String[]{system.name$()});
    }

    private System findSystem(String id) {
        return this.box.graph().systemList().stream().filter(s -> s.alias().equals(id)).findFirst().orElse(null);
    }
}

