/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.checkers.ServerStatusChecker;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerDigest;
import io.intino.consul.schemas.ServerStatus;
import io.intino.ness.inl.Message;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.rules.TimeScale;
import java.time.Instant;

public class ServerStatusMessageHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        ServerStatus status = (ServerStatus)this.message.as(ServerStatus.class);
        Server device = this.findServer(status.id());
        if (device == null) {
            return;
        }
        this.mount(device, status);
        new ServerStatusChecker(device, this.box).check();
    }

    private void mount(Server server, ServerStatus status) {
        server.status(new ServerDigest(this.createDigest(server, TimeScale.FifteenMinutes, status)));
        this.createDigest(server, TimeScale.Hour, status);
        this.createDigest(server, TimeScale.SixHours, status);
        this.createDigest(server, TimeScale.Day, status);
        this.createDigest(server, TimeScale.Month, status);
        this.createDigest(server, TimeScale.Year, status);
    }

    private Digest createDigest(Server server, TimeScale scale, ServerStatus status) {
        Digest digest = this.newDigest(scale, server, status.ts());
        digest.set("cpu", (float)status.cpu());
        digest.set("hdd", (float)status.hdd());
        digest.set("memory", (float)status.memory());
        digest.set("inboundConnections", status.inboundConnections().intValue());
        digest.set("outboundConnections", status.outboundConnections().intValue());
        digest.save();
        return digest;
    }

    private Digest newDigest(TimeScale scale, Server device, Instant instant) {
        return this.box.graph().deviceCube().getOrCreateBucket(this.box.graph().default$(), scale, instant).digest(new String[]{device.name$()});
    }

    private Server findServer(String name) {
        return this.box.graph().infrastructure().unitList(u -> u instanceof Server).stream().filter(unit -> unit.name$().equals(name)).findFirst().orElse(null);
    }
}

