/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.messagehandlers.DeviceFeedHandler;
import io.intino.cesar.box.messagehandlers.infrastructure.Device;
import io.intino.cesar.box.messagehandlers.infrastructure.InfrastructureOperation;
import io.intino.cesar.box.schemas.CommandExecuted;
import io.intino.cesar.countermeasures.notifications.EventNotifier;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Responsible;
import io.intino.ness.inl.Message;
import java.util.List;
import java.util.stream.Collectors;

public class DeviceUpgradeMessageHandler
extends DeviceFeedHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        CommandExecuted command = (CommandExecuted)this.message.as(CommandExecuted.class);
        if (command.remarks().isEmpty()) {
            new Device.Upgrade(this.box, new InfrastructureOperation("upgrade", "cesar", "device", command.deviceId(), new String[]{command.consulVersion()})).execute();
        }
        this.notify(command, this.findDevice(this.box, command.deviceId()));
    }

    private void notify(CommandExecuted command, Device device) {
        List<Responsible> developers = this.developers(device);
        String slackUser = this.box.slackLastActionUser();
        EventNotifier notifier = new EventNotifier(this.box);
        if (slackUser != null && !this.isDeveloper(developers, slackUser)) {
            notifier.notify(slackUser, device.label() + "> ", command.remarks());
        }
        if (this.box.graph().configuration().notifications()) {
            notifier.notify(developers, device.label() + "> ", command.remarks());
        }
    }

    private boolean isDeveloper(List<Responsible> developers, String slackUser) {
        return developers.stream().anyMatch(developer -> developer.asSlackContact().slackChannel().equals(slackUser));
    }

    private List<Responsible> developers(Device device) {
        return device.responsibles().stream().filter(Responsible::isSlackContact).collect(Collectors.toList());
    }
}

