/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.messagehandlers.DeviceFeedHandler;
import io.intino.cesar.box.schemas.Status;
import io.intino.cesar.checkers.DeviceStatusChecker;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceDigest;
import io.intino.ness.inl.Message;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.rules.TimeScale;
import java.time.Instant;

public class DeviceStatusMessageHandler
extends DeviceFeedHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        Status status = (Status)this.message.as(Status.class);
        Device device = this.findDevice(this.box, status.deviceId());
        if (device == null) {
            return;
        }
        this.mount(device, status);
        new DeviceStatusChecker(device, this.box).check();
    }

    private void mount(Device device, Status newStat) {
        device.status(new DeviceDigest(this.createDigest(device, TimeScale.FifteenMinutes, newStat)));
        this.createDigest(device, TimeScale.Hour, newStat);
        this.createDigest(device, TimeScale.SixHours, newStat);
        this.createDigest(device, TimeScale.Day, newStat);
        this.createDigest(device, TimeScale.Month, newStat);
        this.createDigest(device, TimeScale.Year, newStat);
    }

    private Digest createDigest(Device device, TimeScale scale, Status status) {
        Digest digest = this.newDigest(scale, device, status.created());
        digest.set("temperature", (float)status.temperature());
        digest.set("cpuUsage", (float)status.cpuUsage());
        digest.set("battery", (float)status.battery());
        digest.set("isScreenOn", status.isScreenOn() != false ? 1 : 0);
        digest.set("isPlugged", status.isPlugged() != false ? 1 : 0);
        digest.set("consulVersion", Integer.parseInt(status.consulVersion().replace(".", "")));
        digest.save();
        return digest;
    }

    private Digest newDigest(TimeScale scale, Device device, Instant instant) {
        return this.box.graph().deviceCube().getOrCreateBucket(this.box.graph().default$(), scale, instant).digest(new String[]{device.name$()});
    }
}

