/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.messagehandlers.DeviceFeedHandler;
import io.intino.cesar.box.schemas.Crash;
import io.intino.cesar.countermeasures.notifications.EventNotifier;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Responsible;
import io.intino.ness.inl.Message;
import java.util.List;
import java.util.stream.Collectors;

public class DeviceCrashMessageHandler
extends DeviceFeedHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        Crash crash = (Crash)this.message.as(Crash.class);
        Device device = this.findDevice(this.box, crash.deviceId());
        this.notify(crash, device);
    }

    private void notify(Crash crash, Device device) {
        if (!this.box.graph().configuration().notifications()) {
            return;
        }
        new EventNotifier(this.box).notify(this.developers(device), crash.app() + " of " + device.label() + " has crashed at " + crash.created(), crash.stack());
    }

    private List<Responsible> developers(Device device) {
        return device.responsibles().stream().filter(Responsible::isSlackContact).collect(Collectors.toList());
    }
}

