/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.messagehandlers;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.messagehandlers.DeviceFeedHandler;
import io.intino.cesar.box.schemas.Boot;
import io.intino.cesar.countermeasures.notifications.EventNotifier;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.Responsible;
import io.intino.ness.inl.Message;
import java.util.List;
import java.util.stream.Collectors;

public class DeviceBootMessageHandler
extends DeviceFeedHandler {
    public CesarBox box;
    public Message message;

    public void execute() {
        Boot boot = (Boot)this.message.as(Boot.class);
        Device device = this.findDevice(this.box, boot.deviceId());
        if (device != null) {
            this.notify(device, boot);
        }
    }

    private void notify(Device device, Boot boot) {
        if (!this.box.graph().configuration().notifications()) {
            return;
        }
        new EventNotifier(this.box).notify(this.developers(device), "Device " + device.label() + " has been rebooted", "At " + boot.created() + " UTC");
    }

    private List<Responsible> developers(Device device) {
        return device.responsibles().stream().filter(Responsible::isSlackContact).collect(Collectors.toList());
    }
}

