/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box.connectors;

import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.System;
import io.intino.consul.ConsulJMSAccessor;
import io.intino.consul.schemas.Operation;
import io.intino.consul.schemas.OperationResult;
import io.intino.consul.schemas.SystemLog;
import io.intino.consul.schemas.SystemStatus;
import io.intino.konos.datalake.Ness;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;

public class SystemCommander {
    private static Logger logger = Logger.getGlobal();
    private Ness datalake;
    private System system;

    public SystemCommander(Ness datalake, System system) {
        this.datalake = datalake;
        this.system = system;
    }

    public SystemLog log() {
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            Object[] result = new Object[]{null};
            accessor.systemLog(this.system.alias(), log -> {
                result[0] = log;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0] == null ? null : (SystemLog)result[0];
        }
        catch (JMSException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public SystemStatus status() {
        Object[] result = new Object[]{null};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.systemStatus(this.system.alias(), status -> {
                result[0] = status;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0] == null ? null : (SystemStatus)result[0];
        }
        catch (JMSException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        catch (InterruptedException e) {
            return (SystemStatus)result[0];
        }
    }

    public OperationResult operation(String system, Operation operation) {
        Object[] result = new Object[]{null};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.systemOperation(system, operation, value -> {
                result[0] = value;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0] == null ? null : (OperationResult)result[0];
        }
        catch (InterruptedException | JMSException e) {
            return (OperationResult)result[0];
        }
    }

    private ConsulJMSAccessor accessor() {
        if (this.system.consul() == null) {
            return null;
        }
        return new ConsulJMSAccessor(this.datalake.session(), ((Server)this.system.consul().core$().ownerAs(Server.class)).alias());
    }

    public Boolean start() {
        Object[] result = new Object[]{null};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.startSystem(this.system.alias(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0] == null ? null : (Boolean)result[0];
        }
        catch (JMSException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        catch (InterruptedException e) {
            return (Boolean)result[0];
        }
    }

    public Boolean stop() {
        Object[] result = new Object[]{null};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.stopSystem(this.system.alias(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0] == null ? null : (Boolean)result[0];
        }
        catch (JMSException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        catch (InterruptedException e) {
            return (Boolean)result[0];
        }
    }

    public Boolean restart() {
        Object[] result = new Object[]{null};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.restartSystem(this.system.alias(), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0] == null ? null : (Boolean)result[0];
        }
        catch (JMSException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        catch (InterruptedException e) {
            return (Boolean)result[0];
        }
    }

    public Boolean debug() {
        Object[] result = new Object[]{null};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.debugSystem(this.system.alias(), Integer.valueOf(this.system.debugPort()), success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0] == null ? null : (Boolean)result[0];
        }
        catch (JMSException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        catch (InterruptedException e) {
            return (Boolean)result[0];
        }
    }

    public List<Operation> operations() {
        Object[] result = new Object[]{null};
        try {
            Thread thread = Thread.currentThread();
            ConsulJMSAccessor accessor = this.accessor();
            if (accessor == null) {
                return null;
            }
            accessor.systemOperations(this.system.alias(), value -> {
                result[0] = value;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0] == null ? null : (List)result[0];
        }
        catch (JMSException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        catch (InterruptedException e) {
            return (List)result[0];
        }
    }

    public Boolean parameter(System system, String name, String value) {
        ConsulJMSAccessor accessor;
        Thread thread = Thread.currentThread();
        Object[] result = new Object[]{null};
        List<System.Deployment.Parameter> parameters = system.deployment(system.deploymentList().size() - 1).parameterList();
        System.Deployment.Parameter parameter = parameters.stream().filter(p -> p.name$().equals(name)).findFirst().orElse(null);
        if (parameter != null) {
            parameter.value(value);
        }
        if ((accessor = this.accessor()) == null) {
            return null;
        }
        try {
            accessor.parameter(system.alias(), name, value, success -> {
                result[0] = success;
                thread.interrupt();
            });
            Thread.sleep(3000L);
            return result[0] == null ? null : (Boolean)result[0];
        }
        catch (JMSException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        catch (InterruptedException e) {
            return (Boolean)result[0];
        }
    }
}

